/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.GenericDataMatrix;
import gov.usgs.vdx.data.Rank;
import gov.usgs.vdx.db.VDXDatabase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLDataSource {
    protected VDXDatabase database;
    protected String dbName;
    protected Logger logger;
    protected Statement st;
    protected PreparedStatement ps;
    protected ResultSet rs;
    protected String sql;

    public abstract void initialize(ConfigFile var1);

    public abstract String getType();

    public abstract boolean getChannelsFlag();

    public abstract boolean getTranslationsFlag();

    public abstract boolean getRanksFlag();

    public abstract boolean getColumnsFlag();

    public abstract boolean getMenuColumnsFlag();

    public abstract boolean getChannelTypesFlag();

    public abstract boolean databaseExists();

    public abstract boolean createDatabase();

    public abstract void disconnect();

    public void defaultInitialize(ConfigFile params) {
        String driver = params.getString("vdx.driver");
        String url = params.getString("vdx.url");
        String prefix = params.getString("vdx.prefix");
        this.database = new VDXDatabase(driver, url, prefix);
        this.dbName = params.getString("vdx.name") + "$" + this.getType();
        this.logger = Logger.getLogger("gov.usgs.vdx.data.SQLDataSource");
        this.logger.log(Level.INFO, "SQLDataSource.defaultInitialize(" + this.database.getDatabasePrefix() + "_" + this.dbName + ") succeeded.");
    }

    public void defaultDisconnect() {
        this.database.close();
    }

    public boolean defaultDatabaseExists() {
        return this.database.useDatabase(this.dbName);
    }

    public boolean defaultCreateDatabase(boolean channels, boolean translations, boolean channelTypes, boolean ranks, boolean columns, boolean menuColumns) {
        try {
            this.database.useRootDatabase();
            this.ps = this.database.getPreparedStatement("CREATE DATABASE " + this.database.getDatabasePrefix() + "_" + this.dbName);
            this.ps.execute();
            this.database.useDatabase(this.dbName);
            if (channels) {
                this.sql = "CREATE TABLE channels (cid INT PRIMARY KEY AUTO_INCREMENT, code VARCHAR(16) UNIQUE, name VARCHAR(255), lon DOUBLE, lat DOUBLE, height DOUBLE";
                if (translations) {
                    this.sql = this.sql + ", tid INT DEFAULT 1 NOT NULL";
                }
                if (channelTypes) {
                    this.sql = this.sql + ", ctid INT DEFAULT 1 NOT NULL";
                    this.ps.execute("CREATE TABLE channel_types (ctid INT PRIMARY KEY AUTO_INCREMENT, name VARCHAR(16) UNIQUE)");
                    this.ps.execute("INSERT INTO channel_types (name) VALUES ('DEFAULT')");
                }
                this.sql = this.sql + ")";
                this.ps.execute(this.sql);
            }
            if (columns) {
                this.ps.execute("CREATE TABLE columns (colid INT PRIMARY KEY AUTO_INCREMENT, idx INT, name VARCHAR(255) UNIQUE, description VARCHAR(255), unit VARCHAR(255), checked TINYINT, active TINYINT)");
            }
            if (menuColumns) {
                this.ps.execute("CREATE TABLE columns_menu (colid INT PRIMARY KEY AUTO_INCREMENT, idx INT, name VARCHAR(255) UNIQUE, description VARCHAR(255), unit VARCHAR(255), checked TINYINT, active TINYINT)");
            }
            if (ranks) {
                this.ps.execute("CREATE TABLE ranks (rid INT PRIMARY KEY AUTO_INCREMENT,name VARCHAR(24) UNIQUE, rank INT(10) UNSIGNED DEFAULT 0 NOT NULL, user_default TINYINT(1) DEFAULT 0 NOT NULL)");
            }
            this.logger.log(Level.INFO, "SQLDataSource.defaultCreateDatabase(" + this.database.getDatabasePrefix() + "_" + this.dbName + ") succeeded. ");
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultCreateDatabase(" + this.database.getDatabasePrefix() + "_" + this.dbName + ") failed.", e);
            return false;
        }
    }

    public String getChannelName(boolean plural) {
        return plural ? "Channels" : "Channel";
    }

    public boolean defaultCreateChannel(Channel channel, int tid, boolean channels, boolean translations, boolean ranks, boolean columns) {
        return this.defaultCreateChannel(channel.getCode(), channel.getName(), channel.getLon(), channel.getLat(), channel.getHeight(), tid, channels, translations, ranks, columns);
    }

    public boolean defaultCreateChannel(String channelCode, String channelName, double lon, double lat, double height, int tid, boolean channels, boolean translations, boolean ranks, boolean columns) {
        try {
            List<Column> columnsList;
            if (channelCode == null || channelCode.length() == 0) {
                return false;
            }
            if (channelName == null || channelName.length() == 0) {
                channelName = channelCode;
            }
            this.database.useDatabase(this.dbName);
            if (channels) {
                String columnList = "code, name, lon, lat, height";
                String variableList = "?,?,?,?,?";
                if (translations) {
                    columnList = columnList + ",tid";
                    variableList = variableList + ",?";
                }
                this.ps = this.database.getPreparedStatement("INSERT INTO channels (" + columnList + ") VALUES (" + variableList + ")");
                this.ps.setString(1, channelCode);
                this.ps.setString(2, channelName);
                if (Double.isNaN(lon)) {
                    this.ps.setNull(3, 8);
                } else {
                    this.ps.setDouble(3, lon);
                }
                if (Double.isNaN(lat)) {
                    this.ps.setNull(4, 8);
                } else {
                    this.ps.setDouble(4, lat);
                }
                if (Double.isNaN(height)) {
                    this.ps.setNull(5, 8);
                } else {
                    this.ps.setDouble(5, height);
                }
                if (translations) {
                    this.ps.setInt(6, tid);
                }
                this.ps.execute();
            }
            if (columns && (columnsList = this.defaultGetColumns(true, false)).size() > 0) {
                String sql = "CREATE TABLE " + channelCode + " (j2ksec DOUBLE";
                for (int i = 0; i < columnsList.size(); ++i) {
                    sql = sql + "," + columnsList.get((int)i).name + " DOUBLE";
                }
                if (translations) {
                    sql = sql + ",tid INT DEFAULT 1 NOT NULL";
                }
                sql = ranks ? sql + ",rid INT DEFAULT 1 NOT NULL,PRIMARY KEY(j2ksec,rid)" : sql + ",PRIMARY KEY(j2ksec)";
                sql = sql + ",KEY index_j2ksec (j2ksec))";
                this.ps = this.database.getPreparedStatement(sql);
                this.ps.execute(sql);
            }
            this.logger.log(Level.INFO, "SQLDataSource.defaultCreateChannel(" + channelCode + "," + lon + "," + lat + ") succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultCreateChannel(" + channelCode + "," + lon + "," + lat + ") failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return false;
        }
    }

    public boolean defaultCreateTiltChannel(Channel channel, int tid, double azimuth, boolean channels, boolean translations, boolean ranks, boolean columns) {
        try {
            this.defaultCreateChannel(channel, tid, channels, translations, ranks, columns);
            Channel ch = this.defaultGetChannel(channel.getCode(), false);
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("UPDATE channels SET azimuth = ? WHERE cid = ?");
            this.ps.setDouble(1, azimuth);
            this.ps.setInt(2, ch.getCID());
            this.ps.execute();
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultCreateTiltChannel() failed.", e);
            return false;
        }
    }

    public boolean defaultUpdateChannelTranslationID(String channelCode, int tid) {
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("UPDATE channels SET tid = ? WHERE code = ?");
            this.ps.setInt(1, tid);
            this.ps.setString(2, channelCode);
            this.ps.execute();
            this.logger.log(Level.INFO, "SQLDataSource.defaultUpdateChannelTranslationID(" + channelCode + "," + tid + ") succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultUpdateChannelTranslationID(" + channelCode + "," + tid + ") failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return false;
        }
    }

    public boolean defaultCreateTranslation() {
        try {
            this.database.useDatabase(this.dbName);
            boolean exists = false;
            this.rs = this.database.getPreparedStatement("SHOW TABLES LIKE 'translations'").executeQuery();
            if (this.rs.next()) {
                exists = true;
            }
            this.rs.close();
            if (exists) {
                return true;
            }
            List<Column> columns = this.defaultGetColumns(true, false);
            if (columns.size() > 0) {
                this.sql = "CREATE TABLE translations (tid INT PRIMARY KEY AUTO_INCREMENT, name VARCHAR(255)";
                for (int i = 0; i < columns.size(); ++i) {
                    this.sql = this.sql + ",c" + columns.get((int)i).name + " DOUBLE DEFAULT 1,";
                    this.sql = this.sql + " d" + columns.get((int)i).name + " DOUBLE DEFAULT 0 ";
                }
                this.sql = this.sql + ")";
                this.ps.execute(this.sql);
                this.ps.execute("INSERT INTO translations (name) VALUES ('DEFAULT')");
            }
            this.logger.log(Level.INFO, "SQLDataSource.defaultCreateTranslation() succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultCreateTranslation() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return false;
        }
    }

    public boolean defaultInsertColumn(Column column) {
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("INSERT IGNORE INTO columns (idx, name, description, unit, checked, active) VALUES (?,?,?,?,?,?)");
            this.ps.setInt(1, column.idx);
            this.ps.setString(2, column.name);
            this.ps.setString(3, column.description);
            this.ps.setString(4, column.unit);
            this.ps.setBoolean(5, column.checked);
            this.ps.setBoolean(6, column.active);
            this.ps.execute();
            this.logger.log(Level.INFO, "SQLDataSource.defaultInsertColumn(" + column.name + ") succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultInsertColumn(" + column.name + ") failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return false;
        }
    }

    public boolean defaultInsertMenuColumn(Column column) {
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("INSERT IGNORE INTO columns_menu (idx, name, description, unit, checked, active) VALUES (?,?,?,?,?,?)");
            this.ps.setInt(1, column.idx);
            this.ps.setString(2, column.name);
            this.ps.setString(3, column.description);
            this.ps.setString(4, column.unit);
            this.ps.setBoolean(5, column.checked);
            this.ps.setBoolean(6, column.active);
            this.ps.execute();
            this.logger.log(Level.INFO, "SQLDataSource.defaultInsertPlotColumn(" + column.name + ") succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultInsertPlotColumn(" + column.name + ") failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return false;
        }
    }

    public int defaultInsertChannelType(String name) {
        int result = -1;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("INSERT INTO channel_types (name) VALUES (?)");
            this.ps.setString(1, name);
            this.ps.execute();
            this.rs = this.database.getPreparedStatement("SELECT LAST_INSERT_ID()").executeQuery();
            if (this.rs.next()) {
                result = this.rs.getInt(1);
            }
            this.rs.close();
            this.logger.log(Level.INFO, "SQLDataSource.defaultInsertChannelType(" + name + ") succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultInsertChannelType(" + name + ") failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public Rank defaultInsertRank(Rank rank) {
        return this.defaultInsertRank(rank.getName(), rank.getRank(), rank.getUserDefault());
    }

    public Rank defaultInsertRank(String name, int rank, int user_default) {
        Rank result = null;
        try {
            int rid = this.defaultGetRankID(rank);
            if (rid > 0) {
                return this.defaultGetRank(rid);
            }
            this.database.useDatabase(this.dbName);
            if (user_default == 1) {
                this.ps = this.database.getPreparedStatement("UPDATE ranks set user_default = 0");
                this.ps.execute();
            }
            this.ps = this.database.getPreparedStatement("INSERT INTO ranks (name, rank, user_default) VALUES (?,?,?)");
            this.ps.setString(1, name);
            this.ps.setInt(2, rank);
            this.ps.setInt(3, user_default);
            this.ps.execute();
            this.rs = this.database.getPreparedStatement("SELECT LAST_INSERT_ID()").executeQuery();
            if (this.rs.next()) {
                result = this.defaultGetRank(this.rs.getInt(1));
            }
            this.rs.close();
            this.logger.log(Level.INFO, "SQLDataSource.defaultInsertRank(" + name + "," + rank + "," + user_default + ") succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultInsertRank(" + name + "," + rank + "," + user_default + ") failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public int defaultInsertTranslation(String channelCode, GenericDataMatrix gdm) {
        int tid = 1;
        String columns = "";
        String values = "";
        try {
            this.database.useDatabase(this.dbName);
            DoubleMatrix2D dm = gdm.getData();
            String[] columnNames = gdm.getColumnNames();
            for (int i = 0; i < columnNames.length; ++i) {
                columns = columns + columnNames[i] + ",";
                values = values + dm.get(0, i) + ",";
            }
            columns = columns + "name";
            values = values + "'" + channelCode + "'";
            this.ps = this.database.getPreparedStatement("INSERT INTO translations (" + columns + ") VALUES (" + values + ")");
            this.ps.execute();
            tid = this.defaultGetTranslation(channelCode, gdm);
            this.logger.log(Level.INFO, "SQLDataSource.defaultInsertTranslation() succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultInsertTranslation() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return tid;
    }

    public Channel defaultGetChannel(int cid, boolean channelTypes) {
        Channel ch = null;
        int ctid = 0;
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT code, name, lon, lat, height ";
            if (channelTypes) {
                this.sql = this.sql + ",ctid ";
            }
            this.sql = this.sql + "FROM  channels ";
            this.sql = this.sql + "WHERE cid = ?";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.setInt(1, cid);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                String code = this.rs.getString(1);
                String name = this.rs.getString(2);
                double lon = this.rs.getDouble(3);
                if (this.rs.wasNull()) {
                    lon = Double.NaN;
                }
                double lat = this.rs.getDouble(4);
                if (this.rs.wasNull()) {
                    lat = Double.NaN;
                }
                double height = this.rs.getDouble(5);
                if (this.rs.wasNull()) {
                    height = Double.NaN;
                }
                if (channelTypes) {
                    ctid = this.rs.getInt(6);
                }
                ch = new Channel(cid, code, name, lon, lat, height, ctid);
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetChannel(cid) failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return ch;
    }

    public Channel defaultGetChannel(String code, boolean channelTypes) {
        Channel ch = null;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT cid FROM channels WHERE code = ? ");
            this.ps.setString(1, code);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                int cid = this.rs.getInt(1);
                ch = this.defaultGetChannel(cid, channelTypes);
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetChannel(code) failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return ch;
    }

    public List<Channel> defaultGetChannelsList(boolean channelTypes) {
        ArrayList<Channel> result = new ArrayList<Channel>();
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT cid, code, name, lon, lat, height ";
            if (channelTypes) {
                this.sql = this.sql + ",ctid ";
            }
            this.sql = this.sql + "FROM  channels ";
            this.sql = this.sql + "ORDER BY code ";
            this.rs = this.database.getPreparedStatement(this.sql).executeQuery();
            while (this.rs.next()) {
                int cid = this.rs.getInt(1);
                String code = this.rs.getString(2);
                String name = this.rs.getString(3);
                double lon = this.rs.getDouble(4);
                if (this.rs.wasNull()) {
                    lon = Double.NaN;
                }
                double lat = this.rs.getDouble(5);
                if (this.rs.wasNull()) {
                    lat = Double.NaN;
                }
                double height = this.rs.getDouble(6);
                if (this.rs.wasNull()) {
                    height = Double.NaN;
                }
                int ctid = channelTypes ? this.rs.getInt(7) : 0;
                Channel ch = new Channel(cid, code, name, lon, lat, height, ctid);
                result.add(ch);
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetChannelsList() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public List<String> defaultGetChannels(boolean channelTypes) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List<Channel> channelsList = this.defaultGetChannelsList(channelTypes);
            for (Channel channel : channelsList) {
                result.add(channel.toString());
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetChannels() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public List<String> defaultGetChannelTypes() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.database.useDatabase(this.dbName);
            this.rs = this.database.getPreparedStatement("SELECT ctid, name FROM channel_types ORDER BY name").executeQuery();
            while (this.rs.next()) {
                result.add(String.format("%d:%s", this.rs.getInt(1), this.rs.getString(2)));
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetChannelTypes() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public Rank defaultGetRank(Rank rank) {
        return this.defaultGetRank(this.defaultGetRankID(rank.getRank()));
    }

    public Rank defaultGetRank(int rid) {
        Rank result = null;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT rid, name, rank, user_default FROM ranks WHERE rid = ?");
            this.ps.setInt(1, rid);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                result = new Rank(this.rs.getInt(1), this.rs.getString(2), this.rs.getInt(3), this.rs.getInt(4));
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetRank() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public int defaultGetRankID(int rank) {
        int result = -1;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT rid FROM ranks WHERE rank = ?");
            this.ps.setInt(1, rank);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                result = this.rs.getInt(1);
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetRankID() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public List<String> defaultGetRanks() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.database.useDatabase(this.dbName);
            this.rs = this.database.getPreparedStatement("SELECT rid, name, rank, user_default FROM ranks ORDER BY rank").executeQuery();
            while (this.rs.next()) {
                result.add(String.format("%d:%s:%d:%d", this.rs.getInt(1), this.rs.getString(2), this.rs.getInt(3), this.rs.getInt(4)));
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetRanks() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public int defaultGetTranslation(String channelCode, GenericDataMatrix gdm) {
        int result = 1;
        try {
            this.database.useDatabase(this.dbName);
            DoubleMatrix2D dm = gdm.getData();
            String[] columnNames = gdm.getColumnNames();
            this.sql = "";
            for (int i = 0; i < columnNames.length; ++i) {
                this.sql = this.sql + "AND " + columnNames[i] + " = " + dm.get(0, i) + " ";
            }
            this.ps = this.database.getPreparedStatement("SELECT tid FROM translations WHERE name = ? " + this.sql);
            this.ps.setString(1, channelCode);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                result = this.rs.getInt(1);
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetTranslation() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public int defaultGetChannelTranslationID(String channelCode) {
        int result = 1;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT tid FROM channels WHERE code = ?");
            this.ps.setString(1, channelCode);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                result = this.rs.getInt(1);
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetChannelTranslationID() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public List<String> defaultGetMenuColumns(boolean menuColumns) {
        List<Column> columns = this.defaultGetColumns(false, menuColumns);
        ArrayList<String> columnsString = new ArrayList<String>();
        for (int i = 0; i < columns.size(); ++i) {
            columnsString.add(columns.get(i).toString());
        }
        return columnsString;
    }

    public List<Column> defaultGetColumns(boolean allColumns, boolean menuColumns) {
        ArrayList<Column> columns = new ArrayList<Column>();
        String tableName = "";
        tableName = menuColumns ? "columns_menu" : "columns";
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT idx, name, description, unit, checked, active ";
            this.sql = this.sql + "FROM " + tableName + " ";
            if (!allColumns && !menuColumns) {
                this.sql = this.sql + "WHERE active = 1 ";
            }
            this.sql = this.sql + "ORDER BY idx, name";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.rs = this.ps.executeQuery();
            while (this.rs.next()) {
                boolean checked = this.rs.getInt(5) != 0;
                boolean active = this.rs.getInt(6) != 0;
                Column column = new Column(this.rs.getInt(1), this.rs.getString(2), this.rs.getString(3), this.rs.getString(4), checked, active);
                columns.add(column);
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetColumns() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return columns;
    }

    public Column defaultGetColumn(int colid) {
        Column col = null;
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT idx, name, description, unit, checked, active ";
            this.sql = this.sql + "FROM  columns ";
            this.sql = this.sql + "WHERE colid = ?";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.setInt(1, colid);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                int idx = this.rs.getInt(1);
                String name = this.rs.getString(2);
                String description = this.rs.getString(3);
                String unit = this.rs.getString(4);
                boolean checked = this.rs.getInt(5) != 0;
                boolean active = this.rs.getInt(6) != 0;
                col = new Column(idx, name, description, unit, checked, active);
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetColumn(colid) failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return col;
    }

    public Column defaultGetColumn(String name) {
        Column col = null;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT colid FROM columns WHERE name = ? ");
            this.ps.setString(1, name);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                int colid = this.rs.getInt(1);
                col = this.defaultGetColumn(colid);
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetChannel(name) failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return col;
    }

    public List<String> defaultGetOptions(String type) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT idx, code, name ";
            this.sql = this.sql + "FROM   options_" + type + " ";
            this.sql = this.sql + "ORDER BY idx";
            this.rs = this.database.getPreparedStatement(this.sql).executeQuery();
            while (this.rs.next()) {
                result.add(String.format("%d:%s:%s", this.rs.getInt(1), this.rs.getString(2), this.rs.getString(3)));
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetOptions() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public synchronized Date defaultGetLastDataTime(String channelCode) {
        Date lastDataTime = null;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT max(j2ksec) FROM " + channelCode);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                double result = this.rs.getDouble(1);
                lastDataTime = Util.j2KToDate((double)result);
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetLastDataTime() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return lastDataTime;
    }

    public GenericDataMatrix defaultGetData(int cid, int rid, double st, double et, boolean translations, boolean ranks) {
        ArrayList<double[]> pts = new ArrayList<double[]>();
        GenericDataMatrix result = null;
        List<Object> columns = new ArrayList();
        int columnsReturned = 0;
        try {
            int i;
            this.database.useDatabase(this.dbName);
            Channel channel = this.defaultGetChannel(cid, false);
            columns = this.defaultGetColumns(false, false);
            columnsReturned = ranks ? columns.size() + 2 : columns.size() + 1;
            this.sql = "SELECT a.j2ksec";
            if (ranks) {
                this.sql = this.sql + ", c.rid";
            }
            for (i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                this.sql = translations ? this.sql + "," + column.name + " * c" + column.name + " + d" + column.name + " as " + column.name + " " : this.sql + "," + column.name + " ";
            }
            this.sql = this.sql + "FROM " + channel.getCode() + " a ";
            if (translations) {
                this.sql = this.sql + "INNER JOIN translations b on a.tid = b.tid ";
            }
            if (ranks) {
                this.sql = this.sql + "INNER JOIN ranks        c on a.rid = c.rid ";
            }
            this.sql = this.sql + "WHERE j2ksec >= ? ";
            this.sql = this.sql + "AND   j2ksec <= ? ";
            if (ranks && rid != 0) {
                this.sql = this.sql + "AND   c.rid  = ? ";
            } else if (ranks && rid == 0) {
                this.sql = this.sql + "AND   c.rank = (SELECT MAX(e.rank) " + "FROM   " + channel.getCode() + " d, ranks e " + "WHERE  d.rid = e.rid  " + "AND    a.j2ksec = d.j2ksec " + "AND    d.j2ksec >= ? " + "AND    d.j2ksec <= ? ) ";
            }
            this.sql = this.sql + "ORDER BY a.j2ksec ASC";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.setDouble(1, st);
            this.ps.setDouble(2, et);
            if (ranks && rid != 0) {
                this.ps.setInt(3, rid);
            } else {
                this.ps.setDouble(3, st);
                this.ps.setDouble(4, et);
            }
            this.rs = this.ps.executeQuery();
            while (this.rs.next()) {
                double[] dataRow = new double[columnsReturned];
                for (i = 0; i < columnsReturned; ++i) {
                    double value = this.rs.getDouble(i + 1);
                    if (this.rs.wasNull()) {
                        value = Double.NaN;
                    }
                    dataRow[i] = value;
                }
                pts.add(dataRow);
            }
            this.rs.close();
            if (pts.size() > 0) {
                result = new GenericDataMatrix(pts);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultGetData() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public void defaultInsertData(String channelCode, GenericDataMatrix gdm, boolean translations, boolean ranks, int rid) {
        int tid = 1;
        String[] columnNames = gdm.getColumnNames();
        DoubleMatrix2D data = gdm.getData();
        StringBuffer columnBuffer = new StringBuffer();
        StringBuffer valuesBuffer = new StringBuffer();
        try {
            int i;
            this.database.useDatabase(this.dbName);
            for (i = 0; i < columnNames.length; ++i) {
                if (i == 0) {
                    columnBuffer.append(columnNames[i]);
                    valuesBuffer.append("?");
                    continue;
                }
                columnBuffer.append("," + columnNames[i]);
                valuesBuffer.append(",?");
            }
            if (translations) {
                tid = this.defaultGetChannelTranslationID(channelCode);
                columnBuffer.append(",tid");
                valuesBuffer.append("," + tid);
            }
            if (ranks) {
                columnBuffer.append(",rid");
                valuesBuffer.append("," + rid);
            }
            this.sql = "REPLACE INTO " + channelCode + " (" + columnBuffer.toString() + ") VALUES (" + valuesBuffer.toString() + ")";
            String base = channelCode + "(";
            this.ps = this.database.getPreparedStatement(this.sql);
            for (i = 0; i < gdm.rows(); ++i) {
                String output = base;
                for (int j = 0; j < columnNames.length; ++j) {
                    double value = data.getQuick(i, j);
                    if (Double.isNaN(value)) {
                        this.ps.setNull(j + 1, 8);
                    } else {
                        this.ps.setDouble(j + 1, value);
                    }
                    output = output + value + ",";
                }
                this.ps.execute();
                if (translations) {
                    output = output + tid + ",";
                }
                if (ranks) {
                    output = output + rid + ",";
                }
                this.logger.log(Level.INFO, "InsertData() " + this.database.getDatabasePrefix() + "_" + this.dbName + "." + output.substring(0, output.length() - 1) + ")");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.defaultInsertData() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
    }

    public void insertV2TiltData(String code, double j2ksec, double x, double y, double h, double b, double i, double g, double r) {
        try {
            int tid = -1;
            int oid = -1;
            int eid = -1;
            this.database.useV2Database("tilt");
            this.ps = this.database.getPreparedStatement("SELECT curTrans, curOffset, curEnv FROM stations WHERE code=?");
            this.ps.setString(1, code);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                tid = this.rs.getInt(1);
                oid = this.rs.getInt(2);
                eid = this.rs.getInt(3);
            }
            this.rs.close();
            code.toLowerCase();
            this.ps = this.database.getPreparedStatement("INSERT IGNORE INTO " + code + "tilt VALUES (?,?,?,?,?,?,?,?)");
            this.ps.setDouble(1, j2ksec);
            this.ps.setString(2, Util.j2KToDateString((double)j2ksec));
            if (Double.isNaN(x)) {
                this.ps.setNull(3, 8);
            } else {
                this.ps.setDouble(3, x);
            }
            if (Double.isNaN(y)) {
                this.ps.setNull(4, 8);
            } else {
                this.ps.setDouble(4, y);
            }
            if (Double.isNaN(g)) {
                this.ps.setNull(5, 8);
            } else {
                this.ps.setDouble(5, g);
            }
            this.ps.setDouble(6, tid);
            this.ps.setDouble(7, oid);
            this.ps.setDouble(8, 0.0);
            this.ps.execute();
            this.ps = this.database.getPreparedStatement("INSERT IGNORE INTO " + code + "env VALUES (?,?,?,?,?,?,?,?)");
            this.ps.setDouble(1, j2ksec);
            this.ps.setString(2, Util.j2KToDateString((double)j2ksec));
            if (Double.isNaN(h)) {
                this.ps.setNull(3, 8);
            } else {
                this.ps.setDouble(3, h);
            }
            if (Double.isNaN(b)) {
                this.ps.setNull(4, 8);
            } else {
                this.ps.setDouble(4, b);
            }
            if (Double.isNaN(i)) {
                this.ps.setNull(5, 8);
            } else {
                this.ps.setDouble(5, i);
            }
            if (Double.isNaN(r)) {
                this.ps.setNull(6, 8);
            } else {
                this.ps.setDouble(6, r);
            }
            if (Double.isNaN(g)) {
                this.ps.setNull(7, 8);
            } else {
                this.ps.setDouble(7, g);
            }
            this.ps.setDouble(8, eid);
            this.ps.execute();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.insertV2Data() failed.", e);
        }
    }

    public void insertV2StrainData(String code, double j2ksec, double dt01, double dt02, double barometer) {
        try {
            int tid = -1;
            int eid = -1;
            code.toLowerCase();
            this.database.useV2Database("strain");
            this.ps = this.database.getPreparedStatement("SELECT curTrans, curEnvTrans FROM stations WHERE code=?");
            this.ps.setString(1, code);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                tid = this.rs.getInt(1);
                eid = this.rs.getInt(2);
            }
            this.rs.close();
            this.ps = this.database.getPreparedStatement("INSERT IGNORE INTO " + code + "strain (j2ksec, time, dt01, dt02, trans) VALUES (?,?,?,?,?)");
            this.ps.setDouble(1, j2ksec);
            this.ps.setString(2, Util.j2KToDateString((double)j2ksec));
            this.ps.setDouble(3, dt01);
            this.ps.setDouble(4, dt02);
            this.ps.setDouble(5, tid);
            this.ps.execute();
            this.ps = this.database.getPreparedStatement("INSERT IGNORE INTO " + code + "env (j2ksec, time, bar ,trans) VALUES (?,?,?,?)");
            this.ps.setDouble(1, j2ksec);
            this.ps.setString(2, Util.j2KToDateString((double)j2ksec));
            this.ps.setDouble(3, barometer);
            this.ps.setDouble(4, eid);
            this.ps.execute();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.insertV2StrainData() failed.", e);
        }
    }

    public void insertV2GasData(int sid, double t, double co2) {
        try {
            this.database.useV2Database("gas");
            this.ps = this.database.getPreparedStatement("INSERT IGNORE INTO co2 VALUES (?,?,?,?)");
            this.ps.setDouble(1, t);
            this.ps.setInt(2, sid);
            this.ps.setString(3, Util.j2KToDateString((double)t));
            this.ps.setDouble(4, co2);
            this.ps.execute();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLDataSource.insertV2GasData() failed.", e);
        }
    }
}

