/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel {
    private int cid;
    private String code;
    private String name;
    private double lon;
    private double lat;
    private double height;
    private int ctid;

    public Channel(int cid, String code, String name, double lon, double lat, double height, int ctid) {
        this.cid = cid;
        this.code = code;
        this.name = name;
        this.lon = lon;
        this.lat = lat;
        this.height = height;
        this.ctid = ctid;
    }

    public Channel(int cid, String code, String name, double lon, double lat, double height) {
        this(cid, code, name, lon, lat, height, 0);
    }

    public Channel(String ch) {
        String[] parts = ch.split(":");
        this.cid = Integer.parseInt(parts[0]);
        this.code = parts.length > 1 ? parts[1] : null;
        this.name = parts.length > 2 ? parts[2] : this.code;
        this.lon = parts.length > 3 ? Double.parseDouble(parts[3]) : Double.NaN;
        this.lat = parts.length > 4 ? Double.parseDouble(parts[4]) : Double.NaN;
        this.height = parts.length > 5 ? Double.parseDouble(parts[5]) : Double.NaN;
        this.ctid = parts.length > 6 ? Integer.parseInt(parts[6]) : 0;
    }

    public int getCID() {
        return this.cid;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public Point2D.Double getLonLat() {
        return new Point2D.Double(this.lon, this.lat);
    }

    public double getHeight() {
        return this.height;
    }

    public int getCtid() {
        return this.ctid;
    }

    public static Map<Integer, Channel> fromStringsToMap(List<String> ss) {
        HashMap<Integer, Channel> map = new HashMap<Integer, Channel>();
        for (String s : ss) {
            Channel ch = new Channel(s);
            map.put(ch.getCID(), ch);
        }
        return map;
    }

    public String toString() {
        String lon = Double.isNaN(this.getLon()) ? "NaN" : String.valueOf(this.getLon());
        String lat = Double.isNaN(this.getLat()) ? "NaN" : String.valueOf(this.getLat());
        String height = Double.isNaN(this.getHeight()) ? "NaN" : String.valueOf(this.getHeight());
        return String.format("%d:%s:%s:%s:%s:%s:%d", this.getCID(), this.getCode(), this.getName(), lon, lat, height, this.getCtid());
    }
}

