/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.client;

import gov.usgs.net.InternetClient;
import gov.usgs.util.Log;
import gov.usgs.util.Retriable;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.BinaryDataSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VDXClient
extends InternetClient {
    private static final int MAX_RETRIES = 3;
    protected static Map<String, String> dataTypeMap = new HashMap<String, String>();

    public VDXClient(String h, int p) {
        super(h, p);
        this.logger = Log.getLogger((String)"gov.usgs.vdx");
        this.setTimeout(30000);
    }

    public static void addDataType(String t, String c) {
        dataTypeMap.put(t, c);
    }

    protected String submitCommand(Map<String, String> params) throws IOException {
        if (!this.connected()) {
            this.connect();
        }
        String cmd = "getdata: " + Util.mapToString(params) + "\n";
        this.writeString(cmd);
        String rs = this.readString();
        if (rs == null || rs.length() <= 0 || rs.indexOf(58) == -1) {
            return null;
        }
        return rs;
    }

    public BinaryDataSet getBinaryData(final Map<String, String> params) {
        Retriable<BinaryDataSet> rt = new Retriable<BinaryDataSet>("VDXClient.getBinaryData()", 3){

            public void attemptFix() {
                VDXClient.this.close();
                VDXClient.this.connect();
            }

            public boolean attempt() {
                try {
                    String rs = VDXClient.this.submitCommand(params);
                    String rc = rs.substring(0, rs.indexOf(58));
                    String r = rs.substring(rs.indexOf(58) + 1);
                    this.result = null;
                    if (rc.equals("ok")) {
                        System.out.println(r);
                        Map map = Util.stringToMap((String)r);
                        if (map.get("bytes") != null) {
                            int bytes = Integer.parseInt((String)map.get("bytes"));
                            byte[] buffer = VDXClient.this.readBinary(bytes);
                            byte[] decompBuf = Util.decompress((byte[])buffer);
                            ByteBuffer bb = ByteBuffer.wrap(decompBuf);
                            try {
                                System.out.println(":VDX client got type " + (String)map.get("type"));
                                String className = dataTypeMap.get(map.get("type"));
                                BinaryDataSet ds = (BinaryDataSet)Class.forName(className).newInstance();
                                ds.fromBinary(bb);
                                this.result = ds;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            System.out.println("error, expected binary");
                        }
                    } else if (rc.equals("error")) {
                        System.out.println(r);
                    }
                }
                catch (Exception e) {
                    VDXClient.this.logger.warning("VDXClient.getData() exception: " + e.getMessage());
                    return false;
                }
                return true;
            }
        };
        return (BinaryDataSet)rt.go();
    }

    public List<String> getTextData(final Map<String, String> params) {
        Retriable<List<String>> rt = new Retriable<List<String>>("VDXClient.getTestData()", 3){

            public void attemptFix() {
                VDXClient.this.close();
                VDXClient.this.connect();
            }

            public boolean attempt() {
                try {
                    VDXClient.this.logger.info("VDXClient.getData(): params = " + params);
                    String rs = VDXClient.this.submitCommand(params);
                    String rc = rs.substring(0, rs.indexOf(58));
                    String r = rs.substring(rs.indexOf(58) + 1);
                    this.result = null;
                    VDXClient.this.logger.info("VDXClient.getData(): rc = " + rc);
                    VDXClient.this.logger.info("VDXClient.getData(): r = " + r);
                    if (rc.equals("ok")) {
                        Map map = Util.stringToMap((String)r);
                        if (map.get("lines") != null) {
                            int lines = Integer.parseInt((String)map.get("lines"));
                            ArrayList<String> list = new ArrayList<String>();
                            for (int i = 0; i < lines; ++i) {
                                list.add(VDXClient.this.readString());
                            }
                            this.result = list;
                        } else {
                            VDXClient.this.logger.warning("VDXClient.getData(): error, expected text");
                        }
                    }
                }
                catch (Exception e) {
                    VDXClient.this.logger.warning("VDXClient.getData() exception: " + e.getMessage());
                    return false;
                }
                return true;
            }
        };
        return (List)rt.go();
    }

    public static void main(String[] args) {
    }

    static {
        dataTypeMap.put("genericfixed", "gov.usgs.vdx.data.GenericDataMatrix");
        dataTypeMap.put("genericvariable", "gov.usgs.vdx.data.GenericDataMatrix");
        dataTypeMap.put("gps", "gov.usgs.vdx.data.gps.GPSData");
        dataTypeMap.put("helicorder", "gov.usgs.vdx.data.heli.HelicorderData");
        dataTypeMap.put("hypocenters", "gov.usgs.vdx.data.hypo.HypocenterList");
        dataTypeMap.put("rsam", "gov.usgs.vdx.data.rsam.RSAMData");
        dataTypeMap.put("ewrsam", "gov.usgs.vdx.data.rsam.EWRSAMData");
        dataTypeMap.put("tilt", "gov.usgs.vdx.data.tilt.TiltData");
        dataTypeMap.put("wave", "gov.usgs.vdx.data.wave.Wave");
    }
}

