/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui.textvalidator;

import com.isti.util.gui.textvalidator.TextValidator;
import com.isti.util.gui.textvalidator.ValidatedJTextField;
import com.isti.util.gui.textvalidator.ValidatedTextComponent;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class ValidatedCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 1L;
    private final ValidatedTextComponent validatedTextComponent;
    private Object oldValue = null;

    public ValidatedCellEditor(JComboBox comboBox) {
        super(comboBox);
        this.validatedTextComponent = (ValidatedTextComponent)((Object)comboBox);
    }

    public ValidatedCellEditor(JTextField textField) {
        super(textField);
        this.validatedTextComponent = (ValidatedTextComponent)((Object)textField);
    }

    public ValidatedCellEditor(TextValidator tv) {
        this(new ValidatedJTextField(tv));
    }

    protected Color getEditorColor(boolean validFlag) {
        Color color = validFlag ? Color.black : Color.red;
        return color;
    }

    protected String getErrorMessage(String s, TextValidator tv) {
        String message = null;
        if (!tv.isValidEntry(s)) {
            message = "Entry \"" + s + "\" is invalid";
        }
        return message;
    }

    protected JComponent getJComponent() {
        return this.editorComponent;
    }

    protected Component getParentComponent() {
        return null;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        int rowIndex = table.getSelectedRow();
        int columnIndex = table.getSelectedColumn();
        this.oldValue = rowIndex != -1 && columnIndex != -1 ? table.getModel().getValueAt(rowIndex, columnIndex) : null;
        this.validatedTextComponent.setValue(value);
        this.setEditorColor(value);
        return this.getJComponent();
    }

    protected ValidatedTextComponent getValidatedTextComponent() {
        return this.validatedTextComponent;
    }

    protected boolean isEqualEntry(String s) {
        return s.equals(String.valueOf(this.oldValue));
    }

    protected boolean isValidEntry(String s, boolean showDialogFlag) {
        TextValidator tv = this.validatedTextComponent.getTextValidator();
        if (tv == null || this.isEqualEntry(s)) {
            return true;
        }
        return this.isValidEntry(s, tv, showDialogFlag);
    }

    protected boolean isValidEntry(String s, TextValidator tv, boolean showDialogFlag) {
        String message = this.getErrorMessage(s, tv);
        if (message != null) {
            if (showDialogFlag) {
                this.setEditorColor(false);
                String title = "Invalid Entry";
                int option = this.showOptionDialog(message, "Invalid Entry");
                if (option == 2) {
                    this.cancelCellEditing();
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected boolean setEditorColor(boolean validFlag) {
        Color color = this.getEditorColor(validFlag);
        this.setEditorColor(color);
        return validFlag;
    }

    protected void setEditorColor(Color color) {
        this.getJComponent().setBorder(new LineBorder(color));
    }

    protected boolean setEditorColor(Object value) {
        String s = String.valueOf(value);
        boolean validFlag = this.isValidEntry(s, false);
        return this.setEditorColor(validFlag);
    }

    protected int showOptionDialog(String message, String title) {
        return JOptionPane.showOptionDialog(this.getParentComponent(), message, title, 2, 0, null, null, null);
    }

    public boolean stopCellEditing() {
        String s = String.valueOf(super.getCellEditorValue());
        if (this.isValidEntry(s, true)) {
            return super.stopCellEditing();
        }
        return false;
    }
}

