/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.JLabel;

public class SymbolJLabel
extends JLabel {
    public static final int CIRCLE_SYMBOL_OBJECT = 0;
    public static final int RECTANGLE_SYMBOL_OBJECT = 1;
    public static final int TRIANGLE_SYMBOL_OBJECT = 2;
    public static int DEFAULT_SYMBOLSIZE = 0;
    protected static final String DEFAULT_SPACER_STRING = "   ";
    protected static final int SYMBOL_XPOS = 1;
    protected static final Font symFontBold = new Font("Dialog", 1, 12);
    protected static final Font symFontPlain = new Font("Dialog", 0, 12);
    protected String spacerString = "   ";
    protected String labelText = "";
    protected Color colorObj;
    protected Color outlineColorObj = null;
    protected boolean fillFlag = false;
    protected String symbolString = null;
    protected int symbolObj = 0;
    protected boolean boldFlag = false;
    protected static int symbolHeight = 17;
    protected static int symbolWidth = 8;
    protected static boolean symSetupFlag = false;
    protected final Dimension originalDimension;
    protected int symbolSize = DEFAULT_SYMBOLSIZE;
    protected int symbolXOffsetVal = 0;

    public SymbolJLabel(String labelText, Color colorObj, boolean fillFlag) {
        super(DEFAULT_SPACER_STRING + labelText);
        this.labelText = labelText != null ? labelText : "";
        this.colorObj = colorObj;
        this.fillFlag = fillFlag;
        this.originalDimension = this.getPreferredSize();
    }

    public SymbolJLabel(Color colorObj, boolean fillFlag) {
        this("", colorObj, fillFlag);
    }

    public SymbolJLabel(String labelText, Color colorObj, char symbolChar, boolean boldFlag) {
        super(DEFAULT_SPACER_STRING + labelText);
        this.labelText = labelText != null ? labelText : "";
        this.colorObj = colorObj;
        this.symbolString = this.symbolCharToString(symbolChar);
        this.boldFlag = boldFlag;
        this.originalDimension = this.getPreferredSize();
    }

    public SymbolJLabel(Color colorObj, char symbolChar, boolean boldFlag) {
        this("", colorObj, symbolChar, boldFlag);
    }

    public void setLabelText(String str) {
        this.labelText = str != null ? str : "";
        this.setText(this.spacerString + this.labelText);
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setSymbolSize(int symbolSize) {
        this.symbolSize = symbolSize;
        Dimension d = symbolSize > DEFAULT_SYMBOLSIZE ? new Dimension(symbolSize, symbolSize) : this.originalDimension;
        this.setMaximumSize(d);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.updateComponent();
    }

    public void setSpacerString(String str) {
        this.spacerString = str != null ? str : "";
        this.setText(this.spacerString + this.labelText);
    }

    public String getSpacerString() {
        return this.spacerString;
    }

    public void setColorObj(Color colorObj) {
        if (colorObj != null && !colorObj.equals(this.colorObj)) {
            this.colorObj = colorObj;
            this.updateComponent();
        }
    }

    public void setOutlineColorObj(Color colorObj) {
        if (!(colorObj == this.outlineColorObj || colorObj != null && colorObj.equals(this.outlineColorObj))) {
            this.outlineColorObj = colorObj;
            this.updateComponent();
        }
    }

    public void setFillFlag(boolean flgVal) {
        if (flgVal != this.fillFlag) {
            this.fillFlag = flgVal;
            if (!this.isCharSymbol()) {
                this.updateComponent();
            }
        }
    }

    public void setSymbolChar(char symbolChar) {
        String newStr;
        if (symbolChar != '\u0000') {
            newStr = this.symbolCharToString(symbolChar);
            if (newStr.equals(this.symbolString)) {
                return;
            }
        } else {
            if (this.symbolString == null) {
                return;
            }
            newStr = null;
        }
        this.symbolString = newStr;
        this.symbolObj = 0;
        this.updateComponent();
    }

    public void setSymbolObject(int symbolObj) {
        if (this.symbolString != null) {
            this.symbolString = null;
        } else if (this.symbolObj == symbolObj) {
            return;
        }
        this.symbolObj = symbolObj;
        this.updateComponent();
    }

    protected void updateComponent() {
        this.revalidate();
        this.repaint();
    }

    public void clearSymbolChar() {
        this.setSymbolChar('\u0000');
        this.updateComponent();
    }

    public void setBoldFlag(boolean flgVal) {
        if (flgVal != this.boldFlag) {
            this.boldFlag = flgVal;
            if (this.isCharSymbol()) {
                this.updateComponent();
            }
        }
    }

    public void setSymbolXOffset(int offsetVal) {
        this.symbolXOffsetVal = offsetVal;
        this.updateComponent();
    }

    public boolean isCharSymbol() {
        return this.symbolString != null;
    }

    protected String symbolCharToString(char symbolChar) {
        if (symbolChar < ' ' || symbolChar > '\u007f') {
            symbolChar = (char)63;
        }
        return new String(new char[]{symbolChar});
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.colorObj == null) {
            return;
        }
        g.setColor(this.colorObj);
        this.paintSymbol(g, this.fillFlag);
        if (this.fillFlag && this.outlineColorObj != null && !this.outlineColorObj.equals(this.colorObj)) {
            g.setColor(this.outlineColorObj);
            this.paintSymbol(g, false);
        }
    }

    protected void paintSymbol(Graphics g, boolean fillFlag) {
        try {
            if (!symSetupFlag) {
                symbolHeight = g.getFontMetrics(symFontBold).getHeight();
                symbolWidth = g.getFontMetrics(symFontBold).charWidth('O') - 1;
                symSetupFlag = true;
            }
            int width = this.symbolSize > DEFAULT_SYMBOLSIZE ? this.symbolSize : symbolWidth;
            if (this.symbolString == null) {
                int x = this.symbolSize > DEFAULT_SYMBOLSIZE ? (this.getWidth() / 2 - width) / 2 + this.symbolXOffsetVal : 1 + this.symbolXOffsetVal;
                int y = (this.getHeight() - width) / 2;
                if (fillFlag) {
                    switch (this.symbolObj) {
                        case 2: {
                            g.fillPolygon(SymbolJLabel.createTriangle(x, y, width));
                            break;
                        }
                        case 1: {
                            g.fillRect(x, y, width, width);
                            break;
                        }
                        default: {
                            g.fillOval(x, y, width, width);
                            break;
                        }
                    }
                } else {
                    switch (this.symbolObj) {
                        case 2: {
                            g.drawPolygon(SymbolJLabel.createTriangle(x, y, width));
                            break;
                        }
                        case 1: {
                            g.drawRect(x, y, width, width);
                            break;
                        }
                        default: {
                            g.drawOval(x, y, width, width);
                        }
                    }
                }
            } else {
                int txtBase = this.getHeight() / 2 + symbolHeight / 3;
                if (this.boldFlag) {
                    g.setFont(symFontBold);
                    g.drawString(this.symbolString, 2, txtBase);
                } else {
                    g.setFont(symFontPlain);
                    g.drawString(this.symbolString, 1, txtBase);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static Polygon createTriangle(int x, int y, int width) {
        int delta = width / 2;
        int[] xpoints = new int[]{x, x + delta, x + width};
        int[] ypoints = new int[]{y + width, y, y + width};
        int npoints = 3;
        return new Polygon(xpoints, ypoints, 3);
    }
}

