/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.UtilFns;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class NameColorChooserPanel
extends AbstractColorChooserPanel {
    private final JList colorList = new JList<String>(UtilFns.getColorDisplayNames());

    NameColorChooserPanel() {
    }

    public void updateChooser() {
        Color cc = this.getColorFromModel();
        int index = UtilFns.getColorDisplayNameIndex(cc.getRGB());
        if (index >= 0) {
            this.colorList.setSelectedIndex(index);
        } else {
            this.colorList.clearSelection();
        }
    }

    protected void buildChooser() {
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.colorList.setSelectionMode(0);
        this.colorList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int selectedIndex = NameColorChooserPanel.this.colorList.getSelectedIndex();
                if (selectedIndex < 0) {
                    return;
                }
                int value = UtilFns.getColorDisplayNameValue(selectedIndex);
                NameColorChooserPanel.this.getColorSelectionModel().setSelectedColor(new Color(value));
            }
        });
        this.add(this.colorList);
    }

    public String getDisplayName() {
        return "Name";
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }
}

