/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

public class IstiListComboBoxModel
extends AbstractListModel
implements MutableComboBoxModel {
    private static final long serialVersionUID = 1L;
    private final List objects;
    private Object selectedObject;

    public IstiListComboBoxModel(List objects, Object selectedObject) {
        this.objects = objects;
        this.selectedObject = selectedObject;
    }

    public void addElement(Object obj) {
        this.objects.add(obj);
        this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
        if (this.objects.size() == 1 && this.selectedObject == null && obj != null) {
            this.setSelectedItem(obj);
        }
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.objects.size()) {
            return this.objects.get(index);
        }
        return null;
    }

    public Object getSelectedItem() {
        return this.selectedObject;
    }

    public int getSize() {
        return this.objects.size();
    }

    public void insertElementAt(Object obj, int index) {
        this.objects.add(index, obj);
        this.fireIntervalAdded(this, index, index);
    }

    public void removeAllElements() {
        if (this.objects.size() > 0) {
            int firstIndex = 0;
            int lastIndex = this.objects.size() - 1;
            this.objects.clear();
            this.selectedObject = null;
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        } else {
            this.selectedObject = null;
        }
    }

    public void removeElement(Object obj) {
        int index = this.objects.indexOf(obj);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedObject) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.objects.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void setSelectedItem(Object anItem) {
        if (this.selectedObject != null && !this.selectedObject.equals(anItem) || this.selectedObject == null && anItem != null) {
            this.selectedObject = anItem;
            this.fireContentsChanged(this, -1, -1);
        }
    }
}

