/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.gui;

import com.isti.util.UtilFns;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class FilteredDocument
extends PlainDocument {
    public final String specialChars;
    public final boolean numericFlag;
    public final int maxNumChars;
    public final boolean allowFlag;
    private Comparable maxValueObj = null;

    public FilteredDocument(String allowedChars, boolean numericFlag, int maxNumChars) {
        this(allowedChars, numericFlag, maxNumChars, true);
    }

    public FilteredDocument(String specialChars, boolean numericFlag, int maxNumChars, boolean allowFlag) {
        this.specialChars = specialChars;
        this.numericFlag = numericFlag;
        this.maxNumChars = maxNumChars;
        this.allowFlag = allowFlag;
    }

    public void insertString(int insOffs, String insStr, AttributeSet aSet) throws BadLocationException {
        int p;
        int insLen;
        String dataStr = null;
        if (insStr == null || (insLen = insStr.length()) <= 0) {
            return;
        }
        String cmpString = insStr;
        char decimalSeparator = UtilFns.getDecimalSeparator();
        if (this.numericFlag && decimalSeparator != '.') {
            insStr = insStr.replace('.', decimalSeparator);
            cmpString = cmpString.replace(decimalSeparator, '.');
        }
        int dataLen = this.getLength();
        if (this.maxNumChars > 0 && dataLen + insLen > this.maxNumChars) {
            return;
        }
        if (this.specialChars != null && this.specialChars.length() > 0) {
            int q;
            char ch;
            int offs;
            if (this.numericFlag) {
                if (insOffs >= 0 && insOffs <= dataLen) {
                    offs = insOffs;
                    dataStr = (this.getText(0, offs) + insStr + this.getText(offs, dataLen - offs)).toLowerCase();
                    dataLen = dataStr.length();
                } else {
                    dataStr = insStr;
                    offs = dataLen;
                }
            } else {
                offs = 0;
                dataLen = 0;
                dataStr = "";
            }
            p = 0;
            while (this.specialChars.indexOf(ch = cmpString.charAt(p)) < 0 != this.allowFlag && (!this.numericFlag || (ch != '-' && ch != '+' || offs + p <= 0 || dataStr.substring(offs + p - 1, offs + p).equalsIgnoreCase("e") && (offs + p + 1 >= dataLen || "0123456789".indexOf(dataStr.charAt(offs + p + 1)) >= 0)) && (ch != decimalSeparator || (q = dataStr.indexOf(decimalSeparator)) < 0 || q >= dataLen || dataStr.indexOf(decimalSeparator, q + 1) < 0) && (ch != 'e' && ch != 'E' || offs + p != 0 && "0123456789".indexOf(dataStr.charAt(offs + p - 1)) >= 0) && ((q = dataStr.indexOf(101)) < 0 || q >= dataLen || dataStr.indexOf(101, q + 1) < 0)) && ++p < insLen) {
            }
        } else {
            p = insLen;
        }
        if (p > 0) {
            if (this.numericFlag && this.maxValueObj != null) {
                try {
                    Number numberObj = UtilFns.parseNumber(dataStr, this.maxValueObj.getClass());
                    Object compObj = numberObj instanceof Comparable ? (Comparable)((Object)numberObj) : (this.maxValueObj instanceof Integer ? (Number)new Integer(dataStr) : (Number)(this.maxValueObj instanceof Long ? (Number)new Long(dataStr) : (Number)(this.maxValueObj instanceof Float ? (Number)new Float(dataStr) : (Number)(this.maxValueObj instanceof Double ? (Number)new Double(dataStr) : (Number)(this.maxValueObj instanceof Byte ? (Number)new Byte(dataStr) : (Number)(this.maxValueObj instanceof Short ? new Short(dataStr) : null))))));
                    if (compObj != null && compObj.compareTo(this.maxValueObj) > 0) {
                        return;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            super.insertString(insOffs, insStr.substring(0, p), aSet);
        }
    }

    public void setMaxValueObj(Comparable obj) {
        this.maxValueObj = obj;
    }

    public Comparable getMaxValueObj() {
        return this.maxValueObj;
    }
}

