/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.database;

import com.isti.util.database.ConnectionJDBC;
import com.isti.util.database.QueryJDBC;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

public abstract class AbstractDatabase {
    protected static final String EMPTY_TEXT = "";
    private static final String datePattern = "dd-MMM-yyyy";
    private static final String shortDatePattern = "dd-MM-yyyy";
    private static final String timePattern = "HH:mm:ss";
    private final ConnectionJDBC dbConn;
    private QueryJDBC databaseQuery = null;
    private SimpleDateFormat dateFormatterObj = new SimpleDateFormat("dd-MMM-yyyy");
    private SimpleDateFormat shortDateFormatterObj = new SimpleDateFormat("dd-MM-yyyy");
    private SimpleDateFormat timeFormatterObj = new SimpleDateFormat("HH:mm:ss");

    public AbstractDatabase(ConnectionJDBC dbConn) {
        this.dbConn = dbConn;
    }

    public ConnectionJDBC getDatabaseConnection() {
        return this.dbConn;
    }

    public synchronized QueryJDBC getDatabaseQuery() {
        return this.databaseQuery;
    }

    public synchronized void setDatabaseQuery(QueryJDBC dbQuery) {
        this.databaseQuery = dbQuery;
    }

    public abstract String getTableName();

    public abstract String getTablePrefix();

    public abstract String[] getColumnNames();

    public abstract int getColumnOrderNumcolumns();

    public String getColumnPrefix() {
        String text = EMPTY_TEXT;
        if (this.getTablePrefix().length() > 0) {
            text = this.getTablePrefix() + ".";
        }
        return text;
    }

    public synchronized SimpleDateFormat getDateFormatter() {
        return this.getDateFormatter(false);
    }

    public synchronized SimpleDateFormat getDateFormatter(boolean shortFlag) {
        if (shortFlag) {
            return this.shortDateFormatterObj;
        }
        return this.dateFormatterObj;
    }

    public synchronized SimpleDateFormat getTimeFormatter() {
        return this.timeFormatterObj;
    }

    public synchronized void setDateFormatter(SimpleDateFormat dateFormatterObj) {
        this.dateFormatterObj = dateFormatterObj;
    }

    public synchronized void setTimeFormatter(SimpleDateFormat timeFormatterObj) {
        this.timeFormatterObj = timeFormatterObj;
    }

    public abstract String getSelectClause(String var1);

    public abstract String getFromClause(String var1);

    public abstract String getOrderByClause(String var1);

    public void executeQuery(String sql) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        this.setDatabaseQuery(this.dbConn.executeQuery(sql));
    }

    public List getColumnObjects() {
        QueryJDBC dbQuery = this.getDatabaseQuery();
        List l = null;
        if (dbQuery != null) {
            l = dbQuery.getColumnObjects();
        }
        return l;
    }

    public Map getMap(int index) {
        Map map = (Map)this.getColumnObjects().get(index);
        return map;
    }

    public void closeDatabaseConnection() {
        if (this.dbConn != null) {
            this.dbConn.close();
        }
    }

    public abstract String getString(int var1);

    public abstract String getTitle(int var1);
}

