/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.CfgPropValidator;
import com.isti.util.IstiNamedValue;
import com.isti.util.PropItemInterface;
import com.isti.util.UtilFns;

public class PropItem
extends IstiNamedValue
implements PropItemInterface {
    private final String description;
    protected Object auxiliaryObj = null;
    protected Object groupSelObj = null;
    protected CfgPropValidator validatorObj = null;

    public PropItem(String valueName, Object defaultValueObj) {
        this(valueName, defaultValueObj, null, null);
    }

    public PropItem(String valueName, Object defaultValueObj, String descriptionStr) {
        this(valueName, defaultValueObj, null, descriptionStr);
    }

    public PropItem(String valueName, Object defaultValueObj, Object valueObj, String descriptionStr) {
        super(valueName, defaultValueObj, valueObj);
        this.description = descriptionStr == null ? UtilFns.getPrettyString(this.getName()) : descriptionStr;
    }

    public Object clone() {
        return new PropItem(this.getName(), this.getDefaultValue(), this.getValue(), this.description);
    }

    public synchronized Object getAuxiliaryObj() {
        return this.auxiliaryObj;
    }

    public String getDescriptionStr() {
        return this.description;
    }

    public Object getGroupSelObj() {
        return this.groupSelObj;
    }

    public synchronized CfgPropValidator getValidator() {
        return this.validatorObj;
    }

    public synchronized PropItem setAuxiliaryObj(Object obj) {
        this.auxiliaryObj = obj;
        return this;
    }

    public synchronized PropItem setGroupSelObj(Object obj) {
        this.groupSelObj = obj;
        return this;
    }

    public synchronized PropItem setValidator(CfgPropValidator validatorObj) {
        if (PropItem.validateValue(validatorObj, this.getValue())) {
            this.validatorObj = validatorObj;
        }
        return this;
    }

    public static boolean validateValue(CfgPropValidator validatorObj, Object valueObj) {
        if (validatorObj == null) {
            return true;
        }
        if (valueObj instanceof Object[]) {
            Object[] objArr = (Object[])valueObj;
            for (int i = 0; i < objArr.length; ++i) {
                if (validatorObj.validateValue(objArr[i])) continue;
                return false;
            }
            return true;
        }
        return validatorObj.validateValue(valueObj);
    }

    protected synchronized Object checkValue(Object valueObj) {
        if ((valueObj = super.checkValue(valueObj)) != null && !PropItem.validateValue(this.validatorObj, valueObj)) {
            return null;
        }
        return valueObj;
    }
}

