/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.IstiEpochConverter;
import com.isti.util.UtilFns;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class IstiEpoch
implements Comparable,
Comparator {
    public static final String epochFormat = "Epoch";
    public static final String defaultFormat = "Year:Day:Hr:Min";
    public static final String defaultBottomFormat = "Min:Sec";
    private static final String[] formatType = new String[]{"None", "AllTime", "Year:Day:Hr:Min:Sec", "Year:Day:Hr:Min", "Year:Day:Hr", "Year:Day", "Day:Hr:Min:Sec.Msec", "Day:Hr:Min:Sec", "Day:Hr:Min", "Day:Hr:", "Day", "Hr:Min:Sec.MSec", "Hr:Min:Sec", "Hr:Min", "Min:Sec.Msec", "Min:Sec", "Min", "Sec.Msec", "Msec", "Epoch"};
    public static final int None = 0;
    public static final int AllTime = 1;
    public static final int YearDayHrMinSec = 2;
    public static final int YearDayHrMin = 3;
    public static final int YearDayHr = 4;
    public static final int YearDay = 5;
    public static final int DayHrMinSecMsec = 6;
    public static final int DayHrMinSec = 7;
    public static final int DayHrMin = 8;
    public static final int DayHr = 9;
    public static final int Day = 10;
    public static final int HrMinSecMSec = 11;
    public static final int HrMinSec = 12;
    public static final int HrMin = 13;
    public static final int MinSecMsec = 14;
    public static final int MinSec = 15;
    public static final int Min = 16;
    public static final int SecMsec = 17;
    public static final int Msec = 18;
    public static final int Epoch = 19;
    static final String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private IstiEpochConverter _converter = null;
    private long _millisecondsSince1970 = 0L;
    private String message = null;

    public IstiEpoch() {
    }

    public IstiEpoch(Calendar calendar) {
        if (calendar != null) {
            this.setTime(calendar);
        }
    }

    public IstiEpoch(Date date) {
        if (date != null) {
            this.setTime(date);
        }
    }

    public IstiEpoch(double seconds) {
        this.setTime(seconds);
    }

    public IstiEpoch(IstiEpoch epoch) {
        if (epoch != null) {
            this.setTime(epoch);
        }
    }

    public IstiEpoch(long milliseconds) {
        this.setTimeInMillis(milliseconds);
    }

    public IstiEpoch(long seconds, long milliseconds) {
        this.setTime(seconds, milliseconds);
    }

    public IstiEpoch(String respTime) {
        this.setTime(respTime);
    }

    public double absDiff(IstiEpoch epoch) {
        double newTime;
        double thisTime = this.getEpoch();
        if (thisTime > (newTime = epoch.getEpoch())) {
            return thisTime - newTime;
        }
        return newTime - thisTime;
    }

    public void add(double seconds) {
        double curTime = this.getEpoch();
        this.setTime(curTime += seconds);
    }

    public String btimeFormattedString() {
        String year = this.getYear();
        String jday = this.getJDay();
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String retStr = year;
        retStr = retStr.concat(",");
        retStr = retStr.concat(jday);
        retStr = retStr.concat(",");
        retStr = retStr.concat(hr);
        retStr = retStr.concat(":");
        retStr = retStr.concat(mn);
        retStr = retStr.concat(":");
        retStr = retStr.concat(sec);
        retStr = retStr.concat(".");
        retStr = retStr.concat(this.getTenthsMillisecond());
        return retStr;
    }

    public String CanadaFormattedString() {
        String year = this.getYear();
        int mon = this.getIntMonth();
        ++mon;
        int dom = this.getIntDOM();
        String mday = Integer.toString(dom);
        DecimalFormat df = new DecimalFormat("00");
        mday = df.format(dom);
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String smon = Integer.toString(mon);
        smon = df.format(mon);
        String retStr = year;
        retStr = retStr.concat(smon);
        retStr = retStr.concat(mday);
        retStr = retStr.concat(".");
        retStr = retStr.concat(hr);
        retStr = retStr.concat(mn);
        retStr = retStr.concat(sec);
        return retStr;
    }

    public void clear() {
        this.setTimeInMillis(0L);
    }

    public int compare(IstiEpoch time1, IstiEpoch time2) {
        return time1.compareTo(time2);
    }

    public int compare(Object o1, Object o2) throws ClassCastException {
        return this.compare((IstiEpoch)o1, (IstiEpoch)o2);
    }

    public int compareTo(IstiEpoch anotherTime) {
        long rtime = anotherTime.getTimeInMillis();
        long thistime = this.getTimeInMillis();
        if (thistime == rtime) {
            return 0;
        }
        if (thistime > rtime) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object o) throws ClassCastException {
        return this.compareTo((IstiEpoch)o);
    }

    public double diff(IstiEpoch epoch) {
        double thisTime = this.getEpoch();
        double newTime = epoch.getEpoch();
        return thisTime - newTime;
    }

    public boolean equals(Object o) {
        return o instanceof IstiEpoch && this.isEqualTo((IstiEpoch)o);
    }

    public String fileFormattedString() {
        String year = this.getYear();
        String jday = this.getJDay();
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String retStr = year;
        retStr = retStr.concat(".");
        retStr = retStr.concat(jday);
        retStr = retStr.concat(".");
        retStr = retStr.concat(hr);
        retStr = retStr.concat(".");
        retStr = retStr.concat(mn);
        retStr = retStr.concat(".");
        retStr = retStr.concat(sec);
        return retStr;
    }

    public String FissuresFormattedString() {
        String year = this.getYear();
        int mon = this.getIntMonth();
        ++mon;
        int dom = this.getIntDOM();
        String mday = Integer.toString(dom);
        DecimalFormat df = new DecimalFormat("00");
        mday = df.format(dom);
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String retStr = year;
        String smon = Integer.toString(mon);
        smon = df.format(mon);
        retStr = retStr.concat(smon);
        retStr = retStr.concat(mday);
        retStr = retStr.concat("T");
        retStr = retStr.concat(hr);
        retStr = retStr.concat(":");
        retStr = retStr.concat(mn);
        retStr = retStr.concat(":");
        retStr = retStr.concat(sec);
        retStr = retStr.concat(".");
        retStr = retStr.concat(this.getTenthsMillisecond());
        retStr = retStr.concat("Z");
        return retStr;
    }

    public String formatInt(String item, int places) {
        String retString = new String(item);
        if (item.length() >= places) {
            return retString;
        }
        int needed = places - item.length();
        retString = "";
        for (int i = 0; i < needed; ++i) {
            retString = retString.concat("0");
        }
        retString = retString.concat(item);
        return retString;
    }

    public String formattedString() {
        String year = this.getYear();
        String jday = this.getJDay();
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String retStr = year;
        retStr = retStr.concat(":");
        retStr = retStr.concat(jday);
        retStr = retStr.concat(":");
        retStr = retStr.concat(hr);
        retStr = retStr.concat(":");
        retStr = retStr.concat(mn);
        retStr = retStr.concat(":");
        retStr = retStr.concat(sec);
        return retStr;
    }

    public String formattedString(int type) {
        String year = this.getYear();
        String jday = this.getJDay();
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String msec = this.getMSecond();
        String retStr = "";
        switch (type) {
            case 1: {
                retStr = year;
                retStr = retStr.concat(":");
                retStr = retStr.concat(jday);
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                retStr = retStr.concat(".");
                retStr = retStr.concat(msec);
                break;
            }
            case 2: {
                retStr = year;
                retStr = retStr.concat(":");
                retStr = retStr.concat(jday);
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                break;
            }
            case 5: {
                retStr = year;
                retStr = retStr.concat(":");
                retStr = retStr.concat(jday);
                break;
            }
            case 4: {
                retStr = year;
                retStr = retStr.concat(":");
                retStr = retStr.concat(jday);
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                break;
            }
            case 3: {
                retStr = year;
                retStr = retStr.concat(":");
                retStr = retStr.concat(jday);
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                break;
            }
            case 13: {
                retStr = hr;
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                break;
            }
            case 12: {
                retStr = hr;
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                break;
            }
            case 11: {
                retStr = hr;
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                retStr = retStr.concat(".");
                retStr = retStr.concat(msec);
                break;
            }
            case 15: {
                retStr = mn;
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                break;
            }
            case 16: {
                retStr = mn;
                break;
            }
            case 14: {
                retStr = mn;
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                retStr = retStr.concat(".");
                retStr = retStr.concat(msec);
                break;
            }
            case 17: {
                retStr = sec;
                retStr = retStr.concat(".");
                retStr = retStr.concat(msec);
                break;
            }
            case 18: {
                retStr = msec;
                break;
            }
            case 19: {
                retStr = Long.toString(this.getIntEpochSeconds());
                break;
            }
            case 6: {
                retStr = jday;
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                retStr = retStr.concat(".");
                retStr = retStr.concat(msec);
                break;
            }
            case 7: {
                retStr = jday;
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                break;
            }
            case 8: {
                retStr = jday;
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                break;
            }
            case 9: {
                retStr = jday;
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                break;
            }
            case 10: {
                retStr = jday;
                break;
            }
            case 0: {
                retStr = "";
                break;
            }
            default: {
                retStr = "";
            }
        }
        return retStr;
    }

    public String formattedString(String name) {
        for (int i = 0; i < formatType.length; ++i) {
            if (name.compareTo(formatType[i]) != 0) continue;
            return this.formattedString(i);
        }
        return "";
    }

    public int get(int calVal) {
        return this.getConverter().get(this, calVal);
    }

    private final IstiEpochConverter getConverter() {
        if (this._converter == null) {
            this._converter = new IstiEpochConverter();
        }
        return this._converter;
    }

    public double getEpoch() {
        return (double)this.getTimeInMillis() / 1000.0;
    }

    public GregorianCalendar getGregorianCalendar() {
        return this.getConverter().getGregorianCalendar(this);
    }

    public String getHr() {
        String hrStr = Integer.toString(this.getIntInt(11));
        return this.formatInt(hrStr, 2);
    }

    public int getIntDOM() {
        return this.get(5);
    }

    public int getIntDOY() {
        return this.get(6);
    }

    public int getIntEpoch() {
        long longEpoch = this.getIntEpochSeconds();
        int intEpoch = (int)longEpoch;
        if (intEpoch < 0 && longEpoch > 0L) {
            return Integer.MAX_VALUE;
        }
        return intEpoch;
    }

    public long getIntEpochMSecs() {
        return this.getTimeInMillis();
    }

    public long getIntEpochSeconds() {
        return this.getTimeInMillis() / 1000L;
    }

    public int getIntHr() {
        return this.get(11);
    }

    public int getIntInt(int calVal) {
        return this.get(calVal);
    }

    public int getIntMn() {
        return this.get(12);
    }

    public int getIntMonth() {
        return this.get(2);
    }

    public int getIntSec() {
        return this.get(13);
    }

    public int getIntYear() {
        return this.get(1);
    }

    public String getJDay() {
        String retStr = Integer.toString(this.getIntDOY());
        return this.formatInt(retStr, 3);
    }

    public long getLongEpoch() {
        return this.getIntEpochSeconds();
    }

    public int getmDay() {
        return this.get(5);
    }

    public String getMDay() {
        String retStr = Integer.toString(this.getIntMonth());
        return this.formatInt(retStr, 2);
    }

    public String getMessage() {
        return this.message;
    }

    private int getMilliSinceSec() {
        return (int)(this.getTimeInMillis() % 1000L);
    }

    public String getMn() {
        String minStr = Integer.toString(this.getIntInt(12));
        return this.formatInt(minStr, 2);
    }

    public String getMonStr() {
        int day = this.getIntMonth();
        return monthNames[day];
    }

    public String getMsecond(int places) {
        String retStr = null;
        int milliSinceSec = this.getMilliSinceSec();
        if (milliSinceSec == 0) {
            return "0000";
        }
        retStr = Long.toString(milliSinceSec);
        String rv = this.formatInt(retStr, places);
        while (retStr.endsWith("0")) {
            retStr = retStr.substring(0, retStr.length() - 1);
        }
        return rv;
    }

    public String getMSecond() {
        return this.getMsecond(3);
    }

    public String getSecond() {
        String retStr = Integer.toString(this.getIntInt(13));
        return this.formatInt(retStr, 2);
    }

    public String getTenthsMillisecond() {
        String retStr = null;
        int sec = this.getMilliSinceSec();
        if (sec % 1000 == 0) {
            return "0000";
        }
        retStr = Integer.toString(sec);
        String rv = this.formatInt(retStr, 3);
        rv = new String(rv + "0");
        return rv;
    }

    public Date getTime() {
        return this.getConverter().getTime(this);
    }

    public long getTimeInMillis() {
        return this._millisecondsSince1970;
    }

    public TimeZone getTimeZone() {
        return UtilFns.GMT_TIME_ZONE_OBJ;
    }

    public String getYear() {
        int year = this.getIntYear();
        return Integer.toString(year);
    }

    public int hashCode() {
        return (int)(this.getTimeInMillis() ^ this.getTimeInMillis() >>> 32);
    }

    public String hrminsecmsString() {
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String msec = this.getMSecond();
        String retStr = hr;
        retStr = retStr.concat(":");
        retStr = retStr.concat(mn);
        retStr = retStr.concat(":");
        retStr = retStr.concat(sec);
        retStr = retStr.concat(":");
        retStr = retStr.concat(msec);
        return retStr;
    }

    public String hrminsecString() {
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String retStr = hr;
        retStr = retStr.concat(":");
        retStr = retStr.concat(mn);
        retStr = retStr.concat(":");
        retStr = retStr.concat(sec);
        return retStr;
    }

    public boolean inTimeRange(IstiEpoch start, IstiEpoch end) {
        long stime = start.getTimeInMillis();
        long etime = end.getTimeInMillis();
        long thistime = this.getTimeInMillis();
        return thistime >= stime && thistime <= etime;
    }

    public boolean isAfter(double rtime) {
        double thistime = this.getEpoch();
        return thistime > rtime;
    }

    public boolean isAfter(IstiEpoch refTime) {
        long rtime = refTime.getTimeInMillis();
        long thistime = this.getTimeInMillis();
        return thistime > rtime;
    }

    public boolean isAfterEqual(IstiEpoch refTime) {
        long rtime = refTime.getTimeInMillis();
        long thistime = this.getTimeInMillis();
        return thistime >= rtime;
    }

    public boolean isAfterNotEqual(IstiEpoch refTime) {
        long rtime = refTime.getTimeInMillis();
        long thistime = this.getTimeInMillis();
        return thistime > rtime;
    }

    public boolean isBefore(double rtime) {
        double thistime = this.getEpoch();
        return thistime < rtime;
    }

    public boolean isBefore(IstiEpoch refTime) {
        long rtime = refTime.getTimeInMillis();
        long thistime = this.getTimeInMillis();
        return thistime < rtime;
    }

    public boolean isBeforeEqual(IstiEpoch refTime) {
        long rtime = refTime.getTimeInMillis();
        long thistime = this.getTimeInMillis();
        return thistime <= rtime;
    }

    public boolean isBeforeNotEqual(IstiEpoch refTime) {
        long rtime = refTime.getTimeInMillis();
        long thistime = this.getTimeInMillis();
        return thistime < rtime;
    }

    public boolean isEqualTo(IstiEpoch refTime) {
        long rtime = refTime.getTimeInMillis();
        long thistime = this.getTimeInMillis();
        return thistime == rtime;
    }

    public boolean isEvenMinute() {
        int sec = this.getIntInt(13);
        return sec == 0;
    }

    public String ISO8601FormattedString() {
        String year = this.getYear();
        int mon = this.getIntMonth();
        ++mon;
        int dom = this.getIntDOM();
        String mday = Integer.toString(dom);
        DecimalFormat df = new DecimalFormat("00");
        mday = df.format(dom);
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String retStr = year;
        String smon = Integer.toString(mon);
        smon = df.format(mon);
        retStr = retStr.concat(smon);
        retStr = retStr.concat(mday);
        retStr = retStr.concat("T");
        retStr = retStr.concat(hr);
        retStr = retStr.concat(":");
        retStr = retStr.concat(mn);
        retStr = retStr.concat(":");
        retStr = retStr.concat(sec);
        retStr = retStr.concat(".");
        retStr = retStr.concat(this.getTenthsMillisecond());
        retStr = retStr.concat("Z");
        return retStr;
    }

    public String labelformattedString() {
        String retStr = this.yearmondayString();
        return retStr;
    }

    public String longformattedString() {
        String year = this.getYear();
        String jday = this.getJDay();
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String retStr = year;
        retStr = retStr.concat(":");
        retStr = retStr.concat(jday);
        retStr = retStr.concat(":");
        retStr = retStr.concat(hr);
        retStr = retStr.concat(":");
        retStr = retStr.concat(mn);
        retStr = retStr.concat(":");
        retStr = retStr.concat(sec);
        retStr = retStr.concat(".");
        retStr = retStr.concat(this.getMSecond());
        return retStr;
    }

    public String minsecString() {
        String mn = this.getMn();
        String sec = this.getSecond();
        String msec = this.getMSecond();
        String retStr = mn;
        retStr = retStr.concat(":");
        retStr = retStr.concat(sec);
        if (msec == "") {
            return retStr;
        }
        retStr = retStr.concat(".");
        retStr = retStr.concat(msec);
        return retStr;
    }

    public void minus(double seconds) {
        double curTime = this.getEpoch();
        this.setTime(curTime -= seconds);
    }

    public String secString() {
        String sec = this.getSecond();
        String msec = this.getMSecond();
        String retStr = sec;
        if (msec == "") {
            return retStr;
        }
        retStr = retStr.concat(".");
        retStr = retStr.concat(msec);
        return retStr;
    }

    public void set(int year, int month, int day, int hr, int min) {
        this.setYear(year);
        this.setMonth(month);
        this.setmDay(day);
        this.setHr(hr);
        this.setMn(min);
    }

    public void setDateToTODAY() {
        int hr = this.getIntHr();
        int min = this.getIntMn();
        int sec = this.getIntSec();
        int msec = this.getMilliSinceSec();
        this.settoCurrentTime();
        this.setHr(hr);
        this.setMn(min);
        this.setSec(sec);
        this.setMSecond(msec);
    }

    public void setHr(int hour) {
        this.getConverter().set(this, 11, hour);
    }

    public void setIntTime(double seconds) {
        this.setTime(seconds);
    }

    public void setIntTime(int seconds) {
        this.setIntTime((long)seconds);
    }

    public void setIntTime(long seconds) {
        this.setTimeInMillis(seconds * 1000L);
    }

    public void setJDay(int doy) {
        this.getConverter().set(this, 6, doy);
    }

    public void setmDay(int day) {
        this.getConverter().set(this, 5, day);
    }

    public void setMn(int min) {
        this.getConverter().set(this, 12, min);
    }

    public void setMonth(int month) {
        this.getConverter().set(this, 2, month);
    }

    public void setMSecond(int millisecond) {
        this.getConverter().set(this, 14, millisecond);
    }

    public void setSec(int second) {
        this.setSecond(second);
    }

    public void setSecond(int second) {
        this.getConverter().set(this, 13, second);
    }

    public final void setTime(Calendar calendar) {
        this.setTime(calendar.getTime());
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public final void setTime(double dsecs) {
        this.setTimeInMillis((long)(dsecs * 1000.0));
    }

    public void setTime(int year, int jday, int hr, int min, int sec) {
        this.setYear(year);
        this.setJDay(jday);
        this.setHr(hr);
        this.setMn(min);
        this.setSec(sec);
    }

    public final void setTime(IstiEpoch epoch) {
        this.setTimeInMillis(epoch.getTimeInMillis());
    }

    public final void setTime(long msecs) {
        this.setTimeInMillis(msecs);
    }

    public final void setTime(long seconds, long milliseconds) {
        this.setTimeInMillis(seconds * 1000L + milliseconds);
    }

    public final void setTime(String respTime) {
        StringTokenizer st = new StringTokenizer(respTime, ",");
        int count = 0;
        while (st.hasMoreTokens()) {
            String val = st.nextToken().trim();
            if (count == 0) {
                this.setYear(Integer.parseInt(val));
            }
            if (count == 1) {
                this.setJDay(Integer.parseInt(val));
            }
            if (count == 2) {
                StringTokenizer stn = new StringTokenizer(val, ":");
                int ct = 0;
                while (stn.hasMoreTokens()) {
                    val = stn.nextToken().trim();
                    if (ct == 0) {
                        this.setHr(Integer.parseInt(val));
                    }
                    if (ct == 1) {
                        this.setMn(Integer.parseInt(val));
                    }
                    if (ct == 2) {
                        double doubSecs = Double.parseDouble(val);
                        this.setSecond((int)doubSecs);
                    }
                    ++ct;
                }
            }
            ++count;
        }
    }

    public void setTimeAltFissuresTime(String ftime) {
        this.setIntTime(0);
        if (ftime.length() >= 4) {
            int year = Integer.parseInt(ftime.substring(0, 4));
            this.setYear(year);
        }
        if (ftime.length() >= 6) {
            int month = Integer.parseInt(ftime.substring(4, 6));
            this.setMonth(--month);
        }
        if (ftime.length() >= 8) {
            int day = Integer.parseInt(ftime.substring(6, 8));
            this.setmDay(day);
        }
        if (ftime.length() >= 11) {
            int hour = Integer.parseInt(ftime.substring(9, 11));
            this.setHr(hour);
        }
        if (ftime.length() >= 14) {
            int min = Integer.parseInt(ftime.substring(12, 14));
            this.setMn(min);
        }
        if (ftime.length() >= 17) {
            int sec = Integer.parseInt(ftime.substring(15, 17));
            this.setSec(sec);
        }
        if (ftime.length() >= 20) {
            int msec = Integer.parseInt(ftime.substring(18, 20));
            this.setMSecond(msec);
        }
    }

    public void setTimeCanadaTime(String ftime) {
        this.setIntTime(0);
        if (ftime.length() >= 4) {
            int year = Integer.parseInt(ftime.substring(0, 4));
            this.setYear(year);
        }
        if (ftime.length() >= 6) {
            int month = Integer.parseInt(ftime.substring(4, 6));
            this.setMonth(--month);
        }
        if (ftime.length() >= 8) {
            int day = Integer.parseInt(ftime.substring(6, 8));
            this.setmDay(day);
        }
        if (ftime.length() >= 11) {
            int hour = Integer.parseInt(ftime.substring(9, 11));
            this.setHr(hour);
        }
        if (ftime.length() >= 13) {
            int min = Integer.parseInt(ftime.substring(11, 13));
            this.setMn(min);
        }
    }

    public void setTimeFissuresTime(String ftime) {
        StringBuffer sb = new StringBuffer();
        sb.append("IstiEpoch, parsing >" + ftime + "<");
        try {
            this.setIntTime(0);
            int s = 0;
            int e = 4;
            String ts = "";
            if (ftime.length() >= 4) {
                ts = ftime.substring(s, e);
                sb.append("From " + s + " - " + e + " = " + ts);
                int year = Integer.parseInt(ts);
                this.setYear(year);
            }
            if (ftime.length() >= 7) {
                s = 5;
                e = 7;
                ts = ftime.substring(s, e);
                sb.append("From " + s + " - " + e + " = " + ts);
                int month = Integer.parseInt(ts);
                this.setMonth(--month);
            }
            if (ftime.length() >= 10) {
                s = 8;
                e = 10;
                ts = ftime.substring(s, e);
                sb.append("From " + s + " - " + e + " = " + ts);
                int day = Integer.parseInt(ts);
                this.setmDay(day);
            }
            if (ftime.length() >= 13) {
                s = 11;
                e = 13;
                ts = ftime.substring(s, e);
                sb.append("From " + s + " - " + e + " = " + ts);
                int hour = Integer.parseInt(ts);
                this.setHr(hour);
            }
            if (ftime.length() >= 16) {
                s = 14;
                e = 16;
                ts = ftime.substring(s, e);
                sb.append("From " + s + " - " + e + " = " + ts);
                int min = Integer.parseInt(ts);
                this.setMn(min);
            }
            if (ftime.length() >= 19) {
                s = 17;
                e = 19;
                ts = ftime.substring(s, e);
                sb.append("From " + s + " - " + e + " = " + ts);
                int sec = Integer.parseInt(ts);
                this.setSec(sec);
            }
        }
        catch (NumberFormatException ex) {
            sb.append(UtilFns.getStackTraceString(ex));
            this.message = sb.toString();
            throw ex;
        }
        this.message = sb.toString();
    }

    public final void setTimeInMillis(long millis) {
        this._millisecondsSince1970 = millis;
    }

    public void setTimetoDay() {
        int year = this.getIntYear();
        int mon = this.getIntMonth();
        int day = this.getmDay();
        this.setTimeInMillis(0L);
        this.setYear(year);
        this.setMonth(mon);
        this.setmDay(day);
    }

    public void setTimetoDay(IstiEpoch epoch) {
        int year = epoch.getIntYear();
        int mon = epoch.getIntMonth();
        int day = epoch.getmDay();
        this.setTimeInMillis(0L);
        this.setYear(year);
        this.setMonth(mon);
        this.setmDay(day);
    }

    public IstiEpoch settoCurrentTime() {
        this.setTimeInMillis(System.currentTimeMillis());
        return this;
    }

    public void setYear(int year) {
        this.getConverter().set(this, 1, year);
    }

    public String toString() {
        String tstr = this.longformattedString();
        String extra = Double.toString(this.getEpoch());
        tstr.concat(" - " + extra);
        return tstr;
    }

    public String toWaveviewerRequestString() {
        double tDoub = this.getEpoch();
        DecimalFormat dForm = new DecimalFormat();
        dForm.setMinimumIntegerDigits(5);
        dForm.setMaximumIntegerDigits(10);
        dForm.setMaximumFractionDigits(4);
        dForm.setMinimumFractionDigits(3);
        ((NumberFormat)dForm).setGroupingUsed(false);
        String tmp = dForm.format(tDoub);
        return tmp;
    }

    public String yeardayString() {
        String year = this.getYear();
        String jday = this.getJDay();
        String retStr = year;
        retStr = retStr.concat(":");
        retStr = retStr.concat(jday);
        return retStr;
    }

    public String yearmondayhrminString() {
        String year = this.getYear();
        String mon = this.getMonStr();
        String mday = this.getMDay();
        String hr = this.getHr();
        String mn = this.getMn();
        String retStr = year;
        retStr = retStr.concat(" ");
        retStr = retStr.concat(mon);
        retStr = retStr.concat(" ");
        retStr = retStr.concat(mday);
        retStr = retStr.concat(" ");
        retStr = retStr.concat(hr);
        retStr = retStr.concat(":");
        retStr = retStr.concat(mn);
        return retStr;
    }

    public String yearmondayString() {
        String year = this.getYear();
        String mon = this.getMonStr();
        String mday = this.getMDay();
        String retStr = year;
        retStr = retStr.concat(" ");
        retStr = retStr.concat(mon);
        retStr = retStr.concat(" ");
        retStr = retStr.concat(mday);
        return retStr;
    }

    public static String[] getFormattedStrings() {
        return formatType;
    }

    public static String getFormatType(int type) {
        return formatType[type];
    }

    public static void main(String[] args) {
        System.out.println();
        IstiEpoch ie = new IstiEpoch();
        ie.setTime(10L);
        System.out.println("IstiEpoch: " + ie);
        ie.setTime(1000L);
        System.out.println("IstiEpoch: " + ie);
        ie.setTime(100000L);
        System.out.println("IstiEpoch: " + ie);
        IstiEpoch time0 = new IstiEpoch("2003,111,01:10:01");
        time0.setTimeFissuresTime("1965-01-27T12:09:10.033Z");
        IstiEpoch time1 = new IstiEpoch();
        IstiEpoch time2 = new IstiEpoch();
        System.out.println();
        System.out.println("time0 is " + time0);
        System.out.println("time1 is " + time1);
        System.out.println("time2 is " + time2);
        Date date0 = time0.getTime();
        Date date1 = time1.getTime();
        Date date2 = time2.getTime();
        System.out.println();
        System.out.println("time1 equals time2: " + time1.equals(time2));
        System.out.println("time1 compare time1 to time2: " + time1.compare(time1, time2));
        int epochComp = time1.compareTo(time2);
        System.out.println("time1 compareTo time2: " + epochComp);
        int dateComp = date1.compareTo(date2);
        if (epochComp != dateComp) {
            System.out.println("Epoch compare " + epochComp + " is not equal to date compare " + dateComp);
        }
        System.out.println();
        System.out.println("time0 equals time2: " + time0.equals(time2));
        System.out.println("time0 compare time0 to time2: " + time0.compare(time0, time2));
        epochComp = time0.compareTo(time2);
        System.out.println("time0 compareTo time2: " + epochComp);
        dateComp = date0.compareTo(date2);
        if (epochComp != dateComp) {
            System.out.println("Epoch compare " + epochComp + " is not equal to date compare " + dateComp);
        }
        System.out.println();
        System.out.println("time1 equals time0: " + time1.equals(time0));
        System.out.println("time1 compare time1 to time0: " + time1.compare(time1, time0));
        epochComp = time1.compareTo(time0);
        System.out.println("time1 compareTo time0: " + epochComp);
        dateComp = date1.compareTo(date0);
        if (epochComp != dateComp) {
            System.out.println("Epoch compare " + epochComp + " is not equal to date compare " + dateComp);
        }
    }

    public static String toString(double seconds) {
        IstiEpoch epoch = new IstiEpoch(seconds);
        String tstr = epoch.longformattedString();
        return tstr;
    }
}

