/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import java.awt.Color;

public class HtmlUtilFns {
    public static final String BOLD_ELEMENT = "B";
    public static final String COLOR_ATTRIBUTE = "COLOR";
    public static final String FONT_ELEMENT = "FONT";
    public static final String HTML_ELEMENT = "HTML";
    private static final String HTML_START_ELEMENT = HtmlUtilFns.getElementText("HTML".toUpperCase(), true, null);

    private HtmlUtilFns() {
    }

    public static String getColorAttributeText(Color color) {
        if (color != null) {
            return "COLOR=" + Integer.toHexString(color.getRGB() & 0xFFFFFF);
        }
        return null;
    }

    private static String getElementText(String element, boolean startFlag, String attributeText) {
        if (element == null) {
            return element;
        }
        StringBuffer sb = new StringBuffer();
        sb.append('<');
        if (!startFlag) {
            sb.append('/');
        }
        sb.append(element);
        if (attributeText != null) {
            sb.append(" " + attributeText);
        }
        sb.append('>');
        return sb.toString();
    }

    public static String getFontText(String s, Color color) {
        return HtmlUtilFns.getText(s, FONT_ELEMENT, HtmlUtilFns.getColorAttributeText(color));
    }

    public static String getHtmlText(String s) {
        if (s != null && !s.toUpperCase().startsWith(HTML_START_ELEMENT)) {
            return HtmlUtilFns.getText(s, HTML_ELEMENT);
        }
        return s;
    }

    public static String getText(String s, String element) {
        return HtmlUtilFns.getText(s, element, null);
    }

    public static String getText(String s, String element, String attributeText) {
        if (s != null && element != null) {
            return HtmlUtilFns.getElementText(element, true, attributeText) + s + HtmlUtilFns.getElementText(element, false, null);
        }
        return s;
    }
}

