/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.tools;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.sod.SodUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeParser
extends StringParser {
    private Pattern datePattern = Pattern.compile("(\\-?\\d{4})-?(\\d{2})?-?(\\d{2})?-?(\\d{2})?-?(\\d{2})?-?(\\d{2})?");
    private boolean ceiling;
    public static final String FIRST_SEISMOGRAM = "1889-04-17";
    private static final String PREVIOUS_DAY = new SimpleDateFormat("yyyy-MM-dd").format((Date)ClockUtil.now().subtract(new TimeInterval(1.0, UnitImpl.DAY)));
    private static String PREVIOUS_DAY_BEGIN = "the previous day, " + PREVIOUS_DAY;

    public TimeParser(boolean ceiling) {
        this.ceiling = ceiling;
    }

    public Object parse(String arg) throws ParseException {
        if (arg.equals("now")) {
            return "<now/>";
        }
        if (arg.equals(PREVIOUS_DAY_BEGIN)) {
            arg = PREVIOUS_DAY;
        } else if (arg.equals("network")) {
            if (this.ceiling) {
                return "<networkEndTime/>";
            }
            return "<networkStartTime/>";
        }
        return this.parseDate(arg);
    }

    public String parseDate(String arg) throws ParseException {
        return TimeParser.format(this.getMicroSecondDate(arg));
    }

    public static String format(MicroSecondDate d) {
        SimpleDateFormat passcalFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        passcalFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return passcalFormat.format((Date)d);
    }

    public static String formatForParsing(MicroSecondDate d) {
        SimpleDateFormat passcalFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        passcalFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return passcalFormat.format((Date)d);
    }

    public MicroSecondDate getMicroSecondDate(String arg) throws ParseException {
        if (arg.equals("now")) {
            return ClockUtil.now();
        }
        Matcher m = this.datePattern.matcher(arg);
        if (!m.matches()) {
            throw new ParseException("A time must be formatted as YYYY[[[[[-MM]-DD]-hh]-mm]-ss] like 2006-11-19, not '" + arg + "'");
        }
        Calendar cal = SodUtil.createCalendar(Integer.parseInt(m.group(1)), this.extract(m, 2), this.extract(m, 3), this.extract(m, 4), this.extract(m, 5), this.extract(m, 6), this.ceiling);
        return new MicroSecondDate(cal.getTime());
    }

    private int extract(Matcher m, int i) {
        if (m.group(i) == null) {
            return -1;
        }
        return Integer.parseInt(m.group(i));
    }

    public static FlaggedOption createYesterdayParam(String name, String helpMessage, boolean ceiling) {
        return TimeParser.createParam(name, PREVIOUS_DAY_BEGIN, helpMessage, ceiling);
    }

    public static FlaggedOption createParam(String name, String defaultTime, String helpMessage, boolean ceiling) {
        return new FlaggedOption(name, (StringParser)new TimeParser(ceiling), defaultTime, false, name.charAt(0), name, helpMessage);
    }
}

