/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.tools;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Option;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.sod.Args;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.UserConfigurationException;
import edu.sc.seis.sod.Version;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.apache.velocity.VelocityContext;
import org.xml.sax.InputSource;

public class CommandLineTool {
    protected boolean requiresStdin = false;
    private List params = new ArrayList();
    protected JSAPResult result;
    private JSAP jsap = new JSAP();
    private String[] args;
    private String commandName;

    public CommandLineTool(String[] args) throws JSAPException {
        this.args = args;
        this.addParams();
        String[] segs = this.getClass().getName().split("\\.");
        this.commandName = segs[segs.length - 1];
        this.result = this.jsap.parse(args);
        if (this.requiresAtLeastOneArg() && args.length == 0) {
            this.result.addException("Must use at least one option", (Exception)new RuntimeException("Must use at least one option"));
        }
    }

    protected boolean requiresAtLeastOneArg() {
        return true;
    }

    protected FlaggedOption createListOption(String id, char shortFlag, String longFlag, String help) {
        return this.createListOption(id, shortFlag, longFlag, help, null, (StringParser)JSAP.STRING_PARSER);
    }

    protected FlaggedOption createListOption(String id, char shortFlag, String longFlag, String help, String defaultArg) {
        return this.createListOption(id, shortFlag, longFlag, help, defaultArg, (StringParser)JSAP.STRING_PARSER);
    }

    protected FlaggedOption createListOption(String id, char shortFlag, String longFlag, String help, String defaultArg, StringParser parser) {
        FlaggedOption listOption = new FlaggedOption(id, parser, defaultArg, false, shortFlag, longFlag, help);
        listOption.setList(true);
        listOption.setListSeparator(',');
        return listOption;
    }

    protected void addParams() throws JSAPException {
        this.add((Parameter)new Switch("version", 'v', "version", "Print SOD's version and exit"));
        this.add((Parameter)new Switch("recipe", 'r', "recipe", "Print the created recipe to stdout instead of running it"));
        this.add((Parameter)new Switch("help", 'h', "help", "Print this message."));
        this.add((Parameter)new FlaggedOption("props", (StringParser)JSAP.STRING_PARSER, null, false, 'p', "props", "Use an additional props file"));
    }

    protected void add(Parameter param) throws JSAPException {
        this.jsap.registerParameter(param);
        this.params.add(param);
    }

    public VelocityContext getContext() {
        VelocityContext vc = new VelocityContext();
        for (Object cur : this.params) {
            if (cur instanceof Switch) {
                Switch sw = (Switch)cur;
                if (!this.result.getBoolean(sw.getID())) continue;
                vc.put(sw.getID(), (Object)Boolean.TRUE);
                continue;
            }
            Option param = (Option)cur;
            if (param.isList()) {
                Object[] paramResult = this.result.getObjectArray(param.getID());
                if (paramResult.length <= 0) continue;
                vc.put(param.getID(), (Object)paramResult);
                continue;
            }
            if (this.result.getObject(param.getID()) == null) continue;
            vc.put(param.getID(), this.result.getObject(param.getID()));
        }
        return vc;
    }

    protected boolean isSpecified(Parameter p) {
        return this.result.contains(p.getID());
    }

    public String[] getArgs() {
        return this.args;
    }

    public boolean shouldPrintHelp() {
        return this.result.getBoolean("help");
    }

    public boolean shouldPrintRecipe() {
        return this.result.getBoolean("recipe");
    }

    public boolean shouldPrintVersion() {
        return this.result.getBoolean("version");
    }

    public boolean isSuccess() {
        return this.result.success();
    }

    public InputStream getTemplate() throws IOException {
        String className = this.getClass().getName().replace('.', '/');
        return Start.createInputStream("jar:" + className + ".vm");
    }

    public static void run(CommandLineTool ls) throws Exception {
        Start.checkGCJ();
        if (ls.shouldPrintRecipe()) {
            System.out.println("<sod>");
            System.out.flush();
        }
        Start.setCommandName(ls.commandName);
        Properties props = System.getProperties();
        Initializer.loadProps((InputStream)Start.createInputStream("jar:edu/sc/seis/sod/tools/simple.props"), (Properties)props);
        Initializer.loadProperties((String[])ls.getArgs(), (Properties)props, (boolean)false);
        PropertyConfigurator.configure((Properties)props);
        if (ls.shouldPrintHelp()) {
            System.err.println(Args.makeHelp(ls.commandName, ls.params));
            System.exit(0);
        }
        if (ls.shouldPrintVersion()) {
            System.err.println(ls.commandName + " " + Version.current().getVersion());
            System.exit(0);
        }
        if (!ls.isSuccess()) {
            Start.exit(Args.makeError(ls.commandName, ls.params, ls.result));
        }
        VelocityContext ctx = ls.getContext();
        SimpleVelocitizer sv = new SimpleVelocitizer();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (System.in.available() > 0) {
            String line;
            StringBuffer buff = new StringBuffer();
            InputStreamReader isr = new InputStreamReader(System.in);
            BufferedReader r = new BufferedReader(isr);
            boolean inSod = false;
            while ((line = r.readLine()) != null) {
                if (!inSod && line.indexOf("<sod>") != -1) {
                    inSod = true;
                    continue;
                }
                if (!inSod) continue;
                if (line.indexOf("</sod>") != -1) {
                    inSod = false;
                    continue;
                }
                buff.append(line);
                buff.append('\n');
            }
            if (buff.length() == 0) {
                if (!inSod) {
                    System.err.println("There was input on sysin, but it doesn't look like it was a recipe file");
                }
                System.exit(1);
            }
            ctx.put("additionalArms", (Object)buff.toString());
        } else if (ls.requiresStdin) {
            Start.exit("This tool requires that a recipe be piped into it.");
        } else {
            ctx.put("additionalArms", (Object)"");
        }
        final String result = sv.evaluate(ls.getTemplate(), ctx);
        if (ls.shouldPrintRecipe()) {
            System.out.println(result);
            System.exit(0);
        }
        try {
            Start s = new Start(new Args(new String[]{"-f", "<stream>"}), new Start.InputSourceCreator(){

                @Override
                public InputSource create() {
                    return new InputSource(new StringReader("<sod>\n" + result));
                }
            }, props, true);
            s.start();
        }
        catch (UserConfigurationException e) {
            Start.exit(e.getMessage() + "  SOD will quit now and continue to cowardly quit until this is corrected.");
        }
    }
}

