/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.requestGenerator;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.subsetter.requestGenerator.RequestGenerator;
import org.w3c.dom.Element;

public class OriginOffsetRequest
implements RequestGenerator {
    private TimeInterval beginOffset;
    private TimeInterval endOffset;

    public OriginOffsetRequest(Element config) throws ConfigurationException {
        Element beginEl = DOMHelper.extractElement((Element)config, (String)"beginOffset");
        this.beginOffset = SodUtil.loadTimeInterval(beginEl);
        Element endEl = DOMHelper.extractElement((Element)config, (String)"endOffset");
        this.endOffset = SodUtil.loadTimeInterval(endEl);
    }

    @Override
    public RequestFilter[] generateRequest(CacheEvent event, ChannelImpl channel, CookieJar cookieJar) throws Exception {
        OriginImpl origin = EventUtil.extractOrigin((EventAccessOperations)event);
        MicroSecondDate originDate = new MicroSecondDate(origin.getOriginTime());
        MicroSecondDate bDate = originDate.add(this.beginOffset);
        MicroSecondDate eDate = originDate.add(this.endOffset);
        RequestFilter[] filters = new RequestFilter[]{new RequestFilter(channel.get_id(), bDate.getFissuresTime(), eDate.getFissuresTime())};
        return filters;
    }
}

