/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.request;

import edu.iris.Fissures.Dimension;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Plottable;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.NSPlottableDC;
import edu.sc.seis.fissuresUtil.cache.ProxyPlottableDC;
import edu.sc.seis.fissuresUtil.cache.RetryPlottableDC;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import edu.sc.seis.sod.CommonAccess;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.source.AbstractSource;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.request.RequestSubsetter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PlottableRequest
extends AbstractSource
implements RequestSubsetter {
    private ProxyPlottableDC plottableCache;
    private int[] pixelsPerDay;

    public PlottableRequest(Element config) throws Exception {
        super(config, "DelilahCache");
        NodeList dims = config.getElementsByTagName("pixelsPerDay");
        this.pixelsPerDay = new int[dims.getLength()];
        for (int i = 0; i < dims.getLength(); ++i) {
            this.pixelsPerDay[i] = Integer.parseInt(XMLUtil.getText((Element)((Element)dims.item(i))));
        }
        this.plottableCache = new RetryPlottableDC(new NSPlottableDC(this.getDNS(), this.getName(), CommonAccess.getNameService()), 2);
        System.out.println("PlottableRequest: " + this.getName() + " " + this.getDNS() + "  " + this.pixelsPerDay[0]);
    }

    @Override
    public StringTree accept(CacheEvent event, ChannelImpl channel, RequestFilter[] request, CookieJar cookieJar) throws Exception {
        Plottable[] plottables = new Plottable[]{};
        for (int i = 0; i < request.length; ++i) {
            for (int k = 0; k < this.pixelsPerDay.length; ++k) {
                Dimension dimension = new Dimension(this.pixelsPerDay[k], 30);
                plottables = this.plottableCache.get_plottable(request[i], dimension);
            }
        }
        System.out.println("Got " + plottables.length + " plottable for " + ChannelIdUtil.toStringNoDates((Channel)channel) + " " + request[0].start_time.date_time + " to " + request[0].end_time.date_time);
        return new Pass(this);
    }
}

