/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.eventStation;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.AreaSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import org.w3c.dom.Element;

public class MidPoint
extends AreaSubsetter
implements EventStationSubsetter {
    Area area;
    static final QuantityImpl ZERO = new QuantityImpl(0.0, (Unit)UnitImpl.KILOMETER);

    public MidPoint(Element config) throws ConfigurationException {
        super(config);
    }

    @Override
    public StringTree accept(CacheEvent eventAccess, StationImpl station, CookieJar cookieJar) throws Exception {
        Origin origin = eventAccess.get_preferred_origin();
        Location originLoc = origin.getLocation();
        Location loc = station.getLocation();
        double azimuth = SphericalCoords.azimuth((double)originLoc.latitude, (double)originLoc.longitude, (double)loc.latitude, (double)loc.longitude);
        double dist = SphericalCoords.distance((double)originLoc.latitude, (double)originLoc.longitude, (double)loc.latitude, (double)loc.longitude);
        double latitude = SphericalCoords.latFor((double)originLoc.latitude, (double)originLoc.longitude, (double)(dist /= 2.0), (double)azimuth);
        double longitude = SphericalCoords.lonFor((double)originLoc.latitude, (double)originLoc.longitude, (double)dist, (double)azimuth);
        return new StringTreeLeaf(this, this.accept(new Location((float)latitude, (float)longitude, (Quantity)ZERO, (Quantity)ZERO, originLoc.type)), "mid=(" + latitude + ", " + longitude + ")");
    }
}

