/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.RangeSubsetter;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import org.w3c.dom.Element;

public class Sampling
extends RangeSubsetter
implements ChannelSubsetter {
    public Sampling(Element config) throws ConfigurationException {
        super(config, 0.0, 2.147483647E9);
        TimeInterval interval = SodUtil.loadTimeInterval(SodUtil.getElement(config, "interval"));
        this.min = this.getHertz((int)this.getMinValue(), interval);
        this.max = this.getHertz((int)this.getMaxValue(), interval);
    }

    @Override
    public StringTree accept(ChannelImpl channel, NetworkSource network) throws Exception {
        return new StringTreeLeaf(this, this.accept((SamplingImpl)channel.getSamplingInfo()));
    }

    public boolean accept(SamplingImpl channelSampling) {
        return this.accept(this.getHertz(channelSampling));
    }

    double getHertz(int val, TimeInterval interval) {
        return this.getHertz(new SamplingImpl(val, interval));
    }

    double getHertz(SamplingImpl sampling) {
        return sampling.getFrequency().getValue(UnitImpl.HERTZ);
    }
}

