/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.FilterType;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.Response;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.sac.FissuresToSac;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.VelocityFileElementParser;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import edu.sc.seis.sod.velocity.PrintlineVelocitizer;
import java.io.FileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SacPoleZeroWriter
implements ChannelSubsetter {
    public static final String DEFAULT_DIRECTORY = "polezero/";
    public static final String DEFAULT_TEMPLATE = "${channel.codes}.${channel.getStart('yyyy_DDD_HH_mm_ss')}.sacpz";
    private String template;
    private PrintlineVelocitizer velocitizer;
    private static final Logger logger = LoggerFactory.getLogger(SacPoleZeroWriter.class);

    public SacPoleZeroWriter(Element config) throws ConfigurationException {
        VelocityFileElementParser parser = new VelocityFileElementParser(config, DEFAULT_DIRECTORY, DEFAULT_TEMPLATE);
        this.template = parser.getTemplate();
        this.velocitizer = new PrintlineVelocitizer(new String[]{this.template});
    }

    @Override
    public StringTree accept(ChannelImpl chan, NetworkSource network) throws Exception {
        Instrumentation inst;
        ChannelId channel_id = chan.get_id();
        try {
            inst = network.getInstrumentation(channel_id);
        }
        catch (ChannelNotFound e) {
            return new Fail((Object)this, "No instrumentation");
        }
        catch (InvalidResponse e) {
            logger.warn("Invalid instrumentation: ", (Throwable)e);
            return new Fail((Object)this, "Invalid instrumentation: " + e.getMessage());
        }
        if (inst.the_response.stages[0].filters[0].discriminator().value() != 1) {
            String filter = inst.the_response.stages[0].filters[0].discriminator().value() == FilterType.COEFFICIENT.value() ? "COEFFICIENT" : (inst.the_response.stages[0].filters[0].discriminator().value() == FilterType.LIST.value() ? "LIST" : "UNKNOWN: " + inst.the_response.stages[0].filters[0].discriminator().value());
            return new Fail((Object)this, "first (sensor) stage is not a PoleZero filter: " + filter);
        }
        String response = FissuresToSac.getPoleZero((Response)inst.the_response).toString();
        try {
            this.velocitizer.evaluate(this.template, response, (Channel)chan);
        }
        catch (FileNotFoundException fe) {
            GlobalExceptionHandler.handle((String)("Error while writing response file for " + ChannelIdUtil.toString((ChannelId)chan.get_id())), (Throwable)fe);
            return new Fail((Object)this, "Error while writing response file", fe);
        }
        return new Pass(this);
    }
}

