/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.availableData;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.time.CoverageTool;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.ReduceTool;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.availableData.AvailableDataSubsetter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class PercentCoverage
implements AvailableDataSubsetter {
    private double percentage;

    public PercentCoverage(Element content) {
        DOMHelper.extractDouble((Element)content, (String)".", (double)100.0);
    }

    public PercentCoverage(double percentage) {
        this.percentage = percentage;
    }

    @Override
    public StringTree accept(CacheEvent event, ChannelImpl channel, RequestFilter[] request, RequestFilter[] available, CookieJar cookieJar) {
        return new StringTreeLeaf(this, this.accept(request, available));
    }

    public boolean accept(RequestFilter[] original, RequestFilter[] available) {
        return this.percentCovered(original, available) >= this.percentage;
    }

    public double percentCovered(RequestFilter[] request, RequestFilter[] available) {
        RequestFilter[] uncovered = CoverageTool.notCovered((RequestFilter[])request, (RequestFilter[])available);
        TimeInterval totalOriginalTime = this.sum(this.toMSTR(request));
        TimeInterval totalUncoveredTime = this.sum(this.toMSTR(uncovered));
        return (1.0 - totalUncoveredTime.divideBy((QuantityImpl)totalOriginalTime).getValue()) * 100.0;
    }

    private TimeInterval sum(List microSecondTimeRanges) {
        TimeInterval total = new TimeInterval(0.0, UnitImpl.SECOND);
        for (MicroSecondTimeRange time : microSecondTimeRanges) {
            total = total.add(time.getInterval());
        }
        return total;
    }

    private List<MicroSecondTimeRange> toMSTR(RequestFilter[] filters) {
        filters = ReduceTool.merge((RequestFilter[])filters);
        ArrayList<MicroSecondTimeRange> mstrs = new ArrayList<MicroSecondTimeRange>(filters.length);
        for (int i = 0; i < filters.length; ++i) {
            mstrs.add(new MicroSecondTimeRange(filters[i]));
        }
        return mstrs;
    }
}

