/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter;

import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import edu.sc.seis.sod.subsetter.EffectiveTimeOverlap;

public class EventEffectiveTimeOverlap
extends EffectiveTimeOverlap {
    static final TimeInterval DEFAULT_OFFSET = new TimeInterval(3.0, UnitImpl.DAY);

    public EventEffectiveTimeOverlap(StatefulEvent event) throws NoPreferredOrigin {
        super(EventEffectiveTimeOverlap.createTimeRange(event));
    }

    static TimeRange createTimeRange(StatefulEvent event) throws NoPreferredOrigin {
        Time otime = event.getOrigin().getOriginTime();
        if (otime == null) {
            throw new RuntimeException("origin time is null");
        }
        MicroSecondDate originTime = new MicroSecondDate(otime);
        return new TimeRange(originTime.getFissuresTime(), originTime.add(DEFAULT_OFFSET).getFissuresTime());
    }

    public boolean overlaps(NetworkAttr net) {
        return this.overlaps(net.getEffectiveTime());
    }

    public boolean overlaps(Station station) {
        return this.overlaps(station.getEffectiveTime());
    }

    public boolean overlaps(Site site) {
        return this.overlaps(site.getEffectiveTime());
    }

    public boolean overlaps(Channel channel) {
        return this.overlaps(channel.getEffectiveTime());
    }
}

