/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter;

import edu.sc.seis.bag.Bag;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.ScriptUtil;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.UnknownScriptResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class AbstractScriptSubsetter
implements Subsetter {
    protected String script;
    protected Element config;
    protected String scriptType;
    protected ScriptEngine engine;
    protected static ScriptEngineManager factory = new ScriptEngineManager();
    private static final Logger logger = LoggerFactory.getLogger(AbstractScriptSubsetter.class);

    public AbstractScriptSubsetter(Element config) {
        this.config = config;
        this.scriptType = config.getAttribute("type");
        this.engine = factory.getEngineByName(this.scriptType);
        this.script = AbstractScriptSubsetter.cleanScript(SodUtil.getNestedText(config));
    }

    protected Object preeval() throws Exception {
        try {
            if (this.scriptType.equals("jython") || this.scriptType.equals("python")) {
                this.engine.eval("import sys");
                this.engine.eval("sys.path.append('" + Bag.formatForJythonSysPath(Bag.class, (String)"edu/sc/seis/bag/jython") + "')");
                this.engine.eval("from bag import *");
            }
            this.engine.put("result", new Pass(this));
            this.engine.put("util", new ScriptUtil(this));
            Object result = this.engine.eval(this.script);
            return result;
        }
        catch (ScriptException e) {
            logger.error("Problem in script: \n-------------|\n" + this.script + "|-------", (Throwable)e);
            Start.exit("Problem in script: \n-------------|\n" + this.script + "|-------\n\n" + e);
            throw new RuntimeException();
        }
    }

    protected Object pullResult(Object result) throws Exception {
        if (result == null) {
            result = this.engine.get("result");
        }
        if (result == null) {
            return new Pass(this);
        }
        if (result instanceof StringTree) {
            return (StringTree)result;
        }
        if (result instanceof Boolean) {
            return new StringTreeLeaf(this, (boolean)((Boolean)result));
        }
        throw new UnknownScriptResult("Script returns unknown results type, should be boolean or StringTree: " + result.toString());
    }

    protected StringTree eval() throws Exception {
        return (StringTree)this.pullResult(this.preeval());
    }

    public static String cleanScript(String script) {
        if (script.indexOf("\n") == -1) {
            return script.trim();
        }
        String trimBegEnd = script;
        Matcher matcher = Pattern.compile("(?: *\\n)+(.*)", 32).matcher(trimBegEnd);
        if (matcher.matches()) {
            trimBegEnd = matcher.group(1);
        }
        if ((matcher = Pattern.compile("((?:(?: *\\n)*(?: *\\S[^\\n]*\\n)+)+)(?: *\\n?)*").matcher(trimBegEnd)).matches()) {
            trimBegEnd = matcher.group(1);
        }
        String out = "";
        String[] lines = trimBegEnd.split("[\\r?\\n]");
        matcher = Pattern.compile("( *).*").matcher(lines[0]);
        if (matcher.matches()) {
            int numSpaces = matcher.group(1).length();
            Pattern spaceTrimmer = Pattern.compile(" {0," + numSpaces + "}(.*)");
            for (int i = 0; i < lines.length; ++i) {
                matcher = spaceTrimmer.matcher(lines[i]);
                if (!matcher.matches()) {
                    throw new RuntimeException("How can this not match? pat=\"" + spaceTrimmer.pattern() + "\"  |" + lines[i] + "|");
                }
                out = out + matcher.group(1) + "\n";
            }
        } else {
            throw new RuntimeException("Didn't match:" + lines[0] + "|");
        }
        return out;
    }
}

