/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.waveformArm;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.EventChannelPair;
import edu.sc.seis.sod.EventNetworkPair;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.Stage;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.AbstractVelocityStatus;
import edu.sc.seis.sod.status.networkArm.NetworkMonitor;
import edu.sc.seis.sod.status.waveformArm.StationWaveformContext;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.w3c.dom.Element;

public class WaveformStationStatus
extends AbstractVelocityStatus
implements WaveformMonitor,
NetworkMonitor {
    public WaveformStationStatus(String fileDir, String templateName) throws IOException, SQLException {
        super(fileDir, templateName);
        if (Start.getNetworkArm() != null) {
            Start.getNetworkArm().add(this);
        }
    }

    public WaveformStationStatus(Element config) throws IOException, SQLException {
        super(config);
        if (Start.getNetworkArm() != null) {
            Start.getNetworkArm().add(this);
        }
    }

    @Override
    public int getNumDirDeep() {
        return 2;
    }

    @Override
    public void update(EventNetworkPair ecp) {
    }

    @Override
    public void update(EventStationPair ecp) {
    }

    @Override
    public void update(EventChannelPair ecp) {
        Status status = ecp.getStatus();
        if (status.getStage().equals(Stage.PROCESSOR) && status.getStanding().equals(Standing.SUCCESS)) {
            StationImpl station = (StationImpl)ecp.getChannel().getSite().getStation();
            this.doUpdate(station);
        }
    }

    @Override
    public void update(EventVectorPair ecp) {
        Status status = ecp.getStatus();
        if (status.getStage().equals(Stage.PROCESSOR) && status.getStanding().equals(Standing.SUCCESS)) {
            StationImpl station = (StationImpl)ecp.getChannelGroup().getChannels()[0].getSite().getStation();
            this.doUpdate(station);
        }
    }

    protected void doUpdate(StationImpl station) {
        try {
            int stationDbid = station.getDbid();
            VelocityContext context = new VelocityContext((Context)new StationWaveformContext(station));
            context.put("station", (Object)station);
            context.put("networkid", (Object)station.get_id().network_id);
            context.put("network", (Object)station.getNetworkAttr());
            this.scheduleOutput("waveformStations/" + NetworkIdUtil.toStringNoDates((NetworkId)station.get_id().network_id) + "/" + StationIdUtil.toStringNoDates((StationId)station.get_id()) + ".html", (Context)context);
        }
        catch (SQLException e) {
            GlobalExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void setArmStatus(String status) throws Exception {
    }

    @Override
    public void change(Station station, Status s) {
    }

    @Override
    public void change(Channel channel, Status s) {
    }

    @Override
    public void change(NetworkAttrImpl net, Status status) {
    }

    @Override
    public void change(Site site, Status s) {
    }
}

