/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.waveformArm;

import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.EventChannelPair;
import edu.sc.seis.sod.EventNetworkPair;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.EventFormatter;
import edu.sc.seis.sod.status.FileWritingTemplate;
import edu.sc.seis.sod.status.TemplateFileLoader;
import edu.sc.seis.sod.status.eventArm.EventMonitor;
import edu.sc.seis.sod.status.waveformArm.WaveformEventTemplate;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WaveformEventTemplateGenerator
implements EventMonitor,
WaveformMonitor {
    private boolean added = false;
    private WaveformEventTemplate template;
    private Element config;
    private EventFormatter formatter;
    private String fileDir;
    private String filename;
    private static Logger logger = LoggerFactory.getLogger(WaveformEventTemplateGenerator.class);

    public WaveformEventTemplateGenerator(Element el) throws IOException, SAXException, ParserConfigurationException, ConfigurationException {
        this.config = TemplateFileLoader.getTemplate(el);
        Element tmp = SodUtil.getElement(this.config, "outputLocation");
        this.formatter = new EventFormatter(tmp);
        this.config.removeChild(tmp);
        tmp = SodUtil.getElement(this.config, "filename");
        this.filename = tmp.getFirstChild().getNodeValue();
        this.config.removeChild(tmp);
        this.fileDir = FileWritingTemplate.getBaseDirectoryName();
        if (this.formatter == null || this.config == null) {
            throw new IllegalArgumentException("The configuration element must contain a fileDir and a waveformConfig");
        }
        this.template = new WaveformEventTemplate(this.config, this.fileDir, this.formatter, this.filename);
        if (Start.getEventArm() != null) {
            Start.getEventArm().add(this);
        }
    }

    @Override
    public void change(CacheEvent event, Status status) {
        if (!this.added && Start.getWaveformRecipe() != null) {
            Start.getWaveformRecipe().addStatusMonitor(this.template);
            this.added = true;
        }
        this.template.update(event, status);
    }

    @Override
    public void setArmStatus(String status) {
    }

    @Override
    public void update(EventNetworkPair ecp) {
        this.template.update(ecp);
    }

    @Override
    public void update(EventStationPair ecp) {
        this.template.update(ecp);
    }

    @Override
    public void update(EventChannelPair ecp) {
        this.template.update(ecp);
    }

    @Override
    public void update(EventVectorPair ecp) {
        this.template.update(ecp);
    }
}

