/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.waveformArm;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.EventChannelPair;
import edu.sc.seis.sod.EventNetworkPair;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.Stage;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.EventFormatter;
import edu.sc.seis.sod.status.FileWritingTemplate;
import edu.sc.seis.sod.status.GenericTemplate;
import edu.sc.seis.sod.status.MenuTemplate;
import edu.sc.seis.sod.status.OutputScheduler;
import edu.sc.seis.sod.status.Template;
import edu.sc.seis.sod.status.TemplateFileLoader;
import edu.sc.seis.sod.status.eventArm.EventTemplate;
import edu.sc.seis.sod.status.waveformArm.EventStationGroupTemplate;
import edu.sc.seis.sod.status.waveformArm.MapWaveformStatus;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class WaveformEventTemplate
extends Template
implements WaveformMonitor {
    private Map toBeRendered = Collections.synchronizedMap(new HashMap());
    private EventFormatter dirNameCreator;
    private String pageName;
    private String baseDir;
    private MapWaveformStatus map;
    private Writer writer = new Writer();

    public WaveformEventTemplate(Element el, String baseDir, EventFormatter dirNameCreator, String pageName) throws ConfigurationException {
        this.baseDir = baseDir;
        this.dirNameCreator = dirNameCreator;
        this.pageName = pageName;
        this.parse(el);
    }

    public String getOutputDirectory(CacheEvent ev) {
        return this.baseDir + "/" + this.dirNameCreator.getResult(ev) + "/";
    }

    @Override
    protected Object textTemplate(final String text) {
        return new GenericTemplate(){

            @Override
            public String getResult() {
                return text;
            }
        };
    }

    public void update(CacheEvent ev, Status status) {
        String outputDir = this.getOutputDirectory(ev);
        String loc = outputDir + this.pageName;
        if (status.equals(Status.get(Stage.EVENT_ORIGIN_SUBSETTER, Standing.IN_PROG))) {
            try {
                FileWritingTemplate.testOutputLoc(loc);
            }
            catch (IOException e) {
                GlobalExceptionHandler.handle((Throwable)e);
            }
        }
        this.update(ev, outputDir, this.pageName);
    }

    @Override
    public void update(EventNetworkPair ecp) {
        String outputDir = this.getOutputDirectory(ecp.getEvent());
        this.update(ecp.getEvent(), outputDir, this.pageName);
    }

    @Override
    public void update(EventStationPair ecp) {
        String outputDir = this.getOutputDirectory(ecp.getEvent());
        this.update(ecp.getEvent(), outputDir, this.pageName);
    }

    @Override
    public void update(EventChannelPair ecp) {
        String outputDir = this.getOutputDirectory(ecp.getEvent());
        this.update(ecp.getEvent(), outputDir, this.pageName);
    }

    @Override
    public void update(EventVectorPair ecp) {
        String outputDir = this.getOutputDirectory(ecp.getEvent());
        this.update(ecp.getEvent(), outputDir, this.pageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CacheEvent ev, String outputDir, String fileLoc) {
        if (this.map != null) {
            this.map.add((EventAccessOperations)ev, outputDir + "map.png");
        }
        String loc = outputDir + fileLoc;
        Map map = this.toBeRendered;
        synchronized (map) {
            if (!this.toBeRendered.containsKey(loc)) {
                this.toBeRendered.put(loc, ev);
                OutputScheduler.getDefault().schedule(this.writer);
            }
        }
    }

    @Override
    protected Object getTemplate(String tag, Element el) throws ConfigurationException {
        if (tag.equals("eventStations")) {
            return new EventStationGroupTemplate(el);
        }
        if (tag.equals("map")) {
            try {
                if (this.map == null) {
                    this.map = new MapWaveformStatus();
                }
                return new GenericTemplate(){

                    @Override
                    public String getResult() {
                        return "map.png";
                    }
                };
            }
            catch (SQLException e) {
                GlobalExceptionHandler.handle((String)"Trouble connecting to the event channel status db to create the waveform event channel status map", (Throwable)e);
                return new GenericTemplate(){

                    @Override
                    public String getResult() {
                        return "Trouble connecting to the event channel status db to create the map";
                    }
                };
            }
        }
        if (tag.equals("event")) {
            return new EventFormatter(el);
        }
        if (tag.equals("menu")) {
            try {
                return new MenuTemplate(TemplateFileLoader.getTemplate(el), this.baseDir + "/1/2/test.html", this.baseDir);
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle((String)"Problem getting template for Menu", (Throwable)e);
            }
        }
        return super.getTemplate(tag, el);
    }

    public class Writer
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CacheEvent[] evs = new CacheEvent[]{};
            String[] fileLocs = new String[]{};
            Map map = WaveformEventTemplate.this.toBeRendered;
            synchronized (map) {
                int numEvsWaiting = WaveformEventTemplate.this.toBeRendered.size();
                if (WaveformEventTemplate.this.toBeRendered.size() > 0) {
                    evs = new CacheEvent[WaveformEventTemplate.this.toBeRendered.size()];
                    fileLocs = new String[WaveformEventTemplate.this.toBeRendered.size()];
                    for (String loc : WaveformEventTemplate.this.toBeRendered.keySet()) {
                        fileLocs[--numEvsWaiting] = loc;
                        evs[numEvsWaiting] = (CacheEvent)WaveformEventTemplate.this.toBeRendered.get(loc);
                    }
                    WaveformEventTemplate.this.toBeRendered.clear();
                }
            }
            for (int i = 0; i < evs.length; ++i) {
                FileWritingTemplate.write(fileLocs[i], this.getResult(evs[i]));
            }
        }

        private String getResult(CacheEvent ev) {
            StringBuffer buf = new StringBuffer();
            for (Object cur : WaveformEventTemplate.this.templates) {
                if (cur instanceof EventTemplate) {
                    buf.append(((EventTemplate)cur).getResult(ev));
                    continue;
                }
                if (!(cur instanceof GenericTemplate)) continue;
                buf.append(((GenericTemplate)cur).getResult());
            }
            return buf.toString();
        }
    }
}

