/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.waveformArm;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.process.waveform.LocalSeismogramTemplateGenerator;
import edu.sc.seis.sod.status.FileWritingTemplate;
import edu.sc.seis.sod.status.GenericTemplate;
import edu.sc.seis.sod.status.MenuTemplate;
import edu.sc.seis.sod.status.OutputScheduler;
import edu.sc.seis.sod.status.Template;
import edu.sc.seis.sod.status.TemplateFileLoader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.w3c.dom.Element;

public class LocalSeismogramTemplate
extends Template {
    private Writer writer = new Writer();
    private Map toBeRendered = Collections.synchronizedMap(new HashMap());
    private String baseDir;

    public LocalSeismogramTemplate(Element el, String baseDir) throws ConfigurationException {
        this.baseDir = baseDir;
        this.parse(el);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String outputLocation, CookieJar cj) {
        String loc = this.baseDir + outputLocation;
        Map map = this.toBeRendered;
        synchronized (map) {
            if (!this.toBeRendered.containsKey(loc)) {
                this.toBeRendered.put(loc, cj);
                OutputScheduler.getDefault().schedule(this.writer);
            }
        }
    }

    @Override
    protected Object textTemplate(final String text) {
        return new GenericTemplate(){

            @Override
            public String getResult() {
                return text;
            }
        };
    }

    public String getResult(CookieJar cj) {
        StringBuffer buf = new StringBuffer();
        Iterator e = this.templates.iterator();
        while (e.hasNext()) {
            buf.append(((GenericTemplate)e.next()).getResult());
        }
        return LocalSeismogramTemplate.getVelocityResult(buf.toString(), cj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVelocityResult(String template, CookieJar cookieJar) {
        try {
            StringWriter out = new StringWriter();
            VelocityEngine velocityEngine = LocalSeismogramTemplateGenerator.getVelocity();
            synchronized (velocityEngine) {
                boolean status = LocalSeismogramTemplateGenerator.getVelocity().evaluate((Context)new VelocityContext(cookieJar.getContext()), (java.io.Writer)out, "localSeismogramTemplate", template);
            }
            template = out.toString();
        }
        catch (ParseErrorException e) {
            GlobalExceptionHandler.handle((String)"Problem using Velocity", (Throwable)e);
        }
        catch (MethodInvocationException e) {
            GlobalExceptionHandler.handle((String)"Problem using Velocity", (Throwable)e);
        }
        catch (ResourceNotFoundException e) {
            GlobalExceptionHandler.handle((String)"Problem using Velocity", (Throwable)e);
        }
        return template;
    }

    @Override
    protected Object getTemplate(String tag, Element el) throws ConfigurationException {
        if (tag.equals("menu")) {
            try {
                return new MenuTemplate(TemplateFileLoader.getTemplate(el), this.baseDir + "/1/2/3/test.html", this.baseDir);
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle((String)"Problem getting template for Menu", (Throwable)e);
            }
        }
        return super.getTemplate(tag, el);
    }

    public class Writer
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CookieJar[] jars = new CookieJar[]{};
            String[] fileLocs = new String[]{};
            Map map = LocalSeismogramTemplate.this.toBeRendered;
            synchronized (map) {
                int numCookiesWaiting = LocalSeismogramTemplate.this.toBeRendered.size();
                if (LocalSeismogramTemplate.this.toBeRendered.size() > 0) {
                    jars = new CookieJar[LocalSeismogramTemplate.this.toBeRendered.size()];
                    fileLocs = new String[LocalSeismogramTemplate.this.toBeRendered.size()];
                    for (String loc : LocalSeismogramTemplate.this.toBeRendered.keySet()) {
                        fileLocs[--numCookiesWaiting] = loc;
                        jars[numCookiesWaiting] = (CookieJar)LocalSeismogramTemplate.this.toBeRendered.get(loc);
                    }
                    LocalSeismogramTemplate.this.toBeRendered.clear();
                }
            }
            for (int i = 0; i < jars.length; ++i) {
                FileWritingTemplate.write(fileLocs[i], LocalSeismogramTemplate.this.getResult(jars[i]));
            }
        }
    }
}

