/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.eventArm;

import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import edu.sc.seis.sod.status.EventFormatter;
import edu.sc.seis.sod.status.GenericTemplate;
import edu.sc.seis.sod.status.Template;
import edu.sc.seis.sod.status.eventArm.EventTemplate;
import edu.sc.seis.sod.subsetter.origin.EventSorter;
import org.w3c.dom.Element;

public class EventGroupTemplate
extends Template
implements GenericTemplate {
    protected EventSorter sorter = new EventSorter();

    protected EventGroupTemplate() {
    }

    public EventGroupTemplate(Element config) throws ConfigurationException {
        this();
        this.parse(config);
    }

    public static EventGroupTemplate createDefaultTemplate() {
        EventGroupTemplate egt = new EventGroupTemplate();
        egt.useDefaultConfig();
        return egt;
    }

    @Override
    public void parse(Element el) throws ConfigurationException {
        if (!el.hasChildNodes()) {
            this.useDefaultConfig();
        } else {
            super.parse(el);
        }
        if (this.sorter == null) {
            this.sorter = new EventSorter();
        }
    }

    protected void useDefaultConfig() {
        this.templates.add(EventFormatter.getDefaultFormatter());
        this.sorter = new EventSorter();
    }

    @Override
    protected Object getTemplate(String tag, Element el) throws ConfigurationException {
        if (el.getNodeName().equals("eventLabel")) {
            return new EventFormatter(el);
        }
        if (el.getNodeName().equals("sorting")) {
            this.sorter = new EventSorter(el);
            return this.textTemplate("");
        }
        return super.getTemplate(tag, el);
    }

    @Override
    public Object textTemplate(final String text) {
        return new EventTemplate(){

            @Override
            public String getResult(CacheEvent ev) {
                return text;
            }
        };
    }

    @Override
    public String getResult() {
        StringBuffer output = new StringBuffer();
        for (StatefulEvent curEv : this.sorter.getSortedEvents()) {
            for (Object cur : this.templates) {
                if (cur instanceof EventTemplate) {
                    output.append(((EventTemplate)cur).getResult(curEv));
                    continue;
                }
                output.append(cur);
            }
        }
        return output.substring(0, output.length());
    }

    public void setArmStatus(String status) {
    }
}

