/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeSimpleDateFormat;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.status.GenericTemplate;
import java.util.Date;
import java.util.TimeZone;
import org.w3c.dom.Element;

public class TimeTemplate
implements GenericTemplate {
    private ThreadSafeSimpleDateFormat sdf;
    private MicroSecondDate time;
    private boolean representTimeInFuture = true;

    public TimeTemplate(Element config, boolean representTimeInFuture) {
        this.sdf = TimeTemplate.createSDF(config);
        this.representTimeInFuture = representTimeInFuture;
    }

    public TimeTemplate(Element config, Time time) {
        this(config, true);
        this.setTime(time);
    }

    public static ThreadSafeSimpleDateFormat createSDF(Element el) {
        String nestedText;
        if (el != null && (nestedText = SodUtil.getNestedText(el)) != null) {
            return new ThreadSafeSimpleDateFormat(nestedText, TimeZone.getTimeZone("GMT"));
        }
        return new ThreadSafeSimpleDateFormat("yyyy-MM-dd HH:mm:ss z", TimeZone.getTimeZone("GMT"));
    }

    public void setTime(Time t) {
        this.time = new MicroSecondDate(t);
    }

    public String getResult(Time t) {
        this.setTime(t);
        return this.getResult();
    }

    @Override
    public String getResult() {
        if (!this.representTimeInFuture && this.time.after((Date)ClockUtil.tomorrow())) {
            return "-";
        }
        return this.sdf.format((Date)this.time);
    }
}

