/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.Magnitude;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.event.MagnitudeUtil;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeSimpleDateFormat;
import edu.sc.seis.fissuresUtil.display.ParseRegions;
import edu.sc.seis.fissuresUtil.display.UnitDisplayUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.status.Template;
import edu.sc.seis.sod.status.eventArm.EventTemplate;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class EventFormatter
extends Template
implements EventTemplate {
    private static EventFormatter defaultFormatter;
    private static DecimalFormat defaultDecimalFormat;
    private boolean filizeResults;
    static ParseRegions regions;
    private static Logger logger;

    public EventFormatter(boolean filize) throws ConfigurationException {
        this(null, filize);
    }

    public EventFormatter(Element config) throws ConfigurationException {
        this(config, false);
    }

    public static EventFormatter makeTime() {
        try {
            EventFormatter formatter = new EventFormatter(false);
            formatter.templates.clear();
            formatter.templates.add(formatter.getTemplate("originTime", null));
            return formatter;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Shouldn't blow up with a default formatter", e);
        }
    }

    public static EventFormatter makeFilizer() {
        try {
            return new EventFormatter(null, true);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Shouldn't blow up with a default formatter", e);
        }
    }

    public EventFormatter(Element config, boolean filize) throws ConfigurationException {
        if (config == null || !config.hasChildNodes()) {
            this.useDefaultConfig();
        } else {
            this.parse(config, filize);
        }
        this.filizeResults = filize;
    }

    public static EventFormatter getDefaultFormatter() {
        try {
            if (defaultFormatter == null) {
                defaultFormatter = new EventFormatter(false);
            }
        }
        catch (ConfigurationException e) {
            GlobalExceptionHandler.handle((String)"This should never have happened, there is a bug in the default EventFormater.", (Throwable)e);
            throw new RuntimeException("Got configuration exception for default event formater", e);
        }
        return defaultFormatter;
    }

    public static String getDefaultResult(CacheEvent event) {
        return defaultFormatter.getResult(event);
    }

    @Override
    protected Object textTemplate(final String text) {
        return new EventTemplate(){

            @Override
            public String getResult(CacheEvent ev) {
                return text;
            }
        };
    }

    @Override
    protected Object getTemplate(String tag, Element el) {
        if (tag.equals("feRegionName")) {
            return new RegionName();
        }
        if (tag.equals("feRegionNumber")) {
            return new EventTemplate(){

                @Override
                public String getResult(CacheEvent ev) {
                    return Integer.toString(ev.get_attributes().region.number);
                }
            };
        }
        if (tag.equals("depth")) {
            return new EventTemplate(){

                @Override
                public String getResult(CacheEvent ev) {
                    return UnitDisplayUtil.formatQuantityImpl((Quantity)EventFormatter.getOrigin((CacheEvent)ev).getLocation().depth);
                }
            };
        }
        if (tag.equals("latitude")) {
            return new EventTemplate(){

                @Override
                public String getResult(CacheEvent ev) {
                    return EventFormatter.format(EventFormatter.getOrigin((CacheEvent)ev).getLocation().latitude);
                }
            };
        }
        if (tag.equals("longitude")) {
            return new EventTemplate(){

                @Override
                public String getResult(CacheEvent ev) {
                    return EventFormatter.format(EventFormatter.getOrigin((CacheEvent)ev).getLocation().longitude);
                }
            };
        }
        if (tag.equals("magnitude")) {
            return new MagnitudeTemplate();
        }
        if (tag.equals("allMagnitudes")) {
            return new EventTemplate(){

                @Override
                public String getResult(CacheEvent ev) {
                    return EventFormatter.this.getMags(ev);
                }
            };
        }
        if (tag.equals("originTime")) {
            if (el == null) {
                return new Time();
            }
            return new Time(SodUtil.getText(el));
        }
        if (tag.equals("eventStatus")) {
            return new EventStatusFormatter();
        }
        if (tag.equals("waveformChannels")) {
            try {
                return new EventChannelQuery(SodUtil.getNestedText(el));
            }
            catch (NoSuchFieldException e) {
                GlobalExceptionHandler.handle((String)"Unknown standing name passed into event formatter", (Throwable)e);
            }
        }
        return super.getCommonTemplate(tag, el);
    }

    public static String format(double d) {
        return defaultDecimalFormat.format(d);
    }

    public void useDefaultConfig() {
        this.templates.add(new RegionName());
        this.templates.add(this.textTemplate("_"));
        this.templates.add(new Time());
    }

    @Override
    public synchronized String getResult(CacheEvent event) {
        StringBuffer name = new StringBuffer();
        Iterator it = this.templates.iterator();
        while (it.hasNext()) {
            name.append(((EventTemplate)it.next()).getResult(event));
        }
        if (this.filizeResults) {
            return FissuresFormatter.filize(name.toString());
        }
        return name.toString();
    }

    public String getFilizedName(CacheEvent event) {
        return FissuresFormatter.filize(this.getResult(event));
    }

    private String getMags(CacheEvent event) {
        Magnitude[] mags = EventFormatter.getOrigin(event).getMagnitudes();
        String result = new String();
        for (int i = 0; i < mags.length; ++i) {
            result = result + MagnitudeUtil.toString((Magnitude)mags[i]) + " ";
        }
        return result;
    }

    public static String getMag(CacheEvent event) {
        Magnitude[] mags = EventFormatter.getOrigin(event).getMagnitudes();
        if (mags.length > 0) {
            return MagnitudeUtil.toString((Magnitude)mags[0]);
        }
        throw new IllegalArgumentException("No magnitudes on event");
    }

    public static Origin getOrigin(CacheEvent event) {
        return EventUtil.extractOrigin((EventAccessOperations)event);
    }

    public static String getRegionName(CacheEvent event) {
        return regions.getRegionName(event.get_attributes().region);
    }

    static {
        defaultDecimalFormat = new DecimalFormat("#.#");
        regions = ParseRegions.getInstance();
        logger = LoggerFactory.getLogger(EventFormatter.class);
    }

    private class EventStatusFormatter
    implements EventTemplate {
        private EventStatusFormatter() {
        }

        @Override
        public String getResult(CacheEvent e) {
            if (e instanceof StatefulEvent) {
                return "" + ((StatefulEvent)e).getStatus();
            }
            return "unknown";
        }
    }

    private class Time
    implements EventTemplate {
        private ThreadSafeSimpleDateFormat sdf;

        public Time() {
            this("yyyyMMdd'T'HH:mm:ss.SSS");
        }

        public Time(String format) {
            this.sdf = new ThreadSafeSimpleDateFormat(format, TimeZone.getTimeZone("GMT"));
        }

        @Override
        public String getResult(CacheEvent ev) {
            try {
                return this.sdf.format((Date)new MicroSecondDate(EventFormatter.getOrigin(ev).getOriginTime()));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Offending date_time: " + EventFormatter.getOrigin((CacheEvent)ev).getOriginTime().date_time, e);
            }
        }
    }

    private class RegionName
    implements EventTemplate {
        private RegionName() {
        }

        @Override
        public String getResult(CacheEvent ev) {
            return EventFormatter.getRegionName(ev);
        }
    }

    private class MagnitudeTemplate
    implements EventTemplate {
        private MagnitudeTemplate() {
        }

        @Override
        public String getResult(CacheEvent ev) {
            return EventFormatter.getMag(ev);
        }
    }

    private class EventChannelQuery
    implements EventTemplate {
        private Standing s;

        public EventChannelQuery(String standing) throws NoSuchFieldException {
            this.s = Standing.getForName(standing);
        }

        @Override
        public String getResult(CacheEvent ev) {
            if (this.s.equals(Standing.SUCCESS)) {
                return "" + SodDB.getSingleton().getNumSuccessful(ev);
            }
            if (this.s.equals(Standing.REJECT)) {
                return "" + SodDB.getSingleton().getNumFailed(ev);
            }
            if (this.s.equals(Standing.RETRY)) {
                return "" + SodDB.getSingleton().getNumRetry(ev);
            }
            throw new RuntimeException("Should never happen: standing=" + this.s);
        }
    }
}

