/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.process.waveform.LocalSeismogramTemplateGenerator;
import edu.sc.seis.sod.status.FileWritingTemplate;
import edu.sc.seis.sod.status.MenuTemplate;
import edu.sc.seis.sod.status.OutputScheduler;
import edu.sc.seis.sod.status.TemplateFileLoader;
import edu.sc.seis.sod.status.networkArm.NetworkMonitor;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractVelocityStatus
implements WaveformMonitor,
NetworkMonitor {
    private String renderedMenu;
    private String fileDir;
    private String templateName;
    private String template = "";

    public AbstractVelocityStatus(Element config) throws SQLException, MalformedURLException, IOException {
        this(FileWritingTemplate.getBaseDirectoryName(), AbstractVelocityStatus.getTemplateName(config));
    }

    public AbstractVelocityStatus(String fileDir, String templateName) throws SQLException, IOException {
        this.fileDir = fileDir;
        this.templateName = templateName;
        this.template = this.loadTemplate(templateName);
        try {
            Element menuEl = TemplateFileLoader.getTemplate(this.getClass().getClassLoader(), "jar:edu/sc/seis/sod/data/templates/menu.xml");
            MenuTemplate menu = new MenuTemplate(menuEl, this.createExamplePath(), fileDir);
            this.renderedMenu = menu.getResult();
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle((String)"Trouble creating menuTemplate for Velocity based status", (Throwable)e);
        }
    }

    public static String getTemplateName(Element config) throws MalformedURLException {
        String templateName = AbstractVelocityStatus.getNestedTextForElement("template", config);
        if (templateName != null) {
            return templateName;
        }
        throw new MalformedURLException("template config param is null");
    }

    public static String getNestedTextForElement(String elementName, Element config) {
        NodeList nl = config.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element element;
            Node n = nl.item(i);
            if (!(n instanceof Element) || !(element = (Element)n).getTagName().equals(elementName)) continue;
            return SodUtil.getNestedText(element);
        }
        return null;
    }

    private String createExamplePath() {
        String path = this.fileDir + '/';
        for (int i = 0; i < this.getNumDirDeep(); ++i) {
            path = path + "dir/";
        }
        return path + "file.html";
    }

    public abstract int getNumDirDeep();

    protected String loadTemplate() throws IOException {
        return this.loadTemplate(this.templateName);
    }

    protected String loadTemplate(String templateName) throws IOException {
        String line;
        URL templateURL = TemplateFileLoader.getUrl(this.getClass().getClassLoader(), templateName);
        BufferedReader read = new BufferedReader(new InputStreamReader(templateURL.openStream()));
        String outTemplate = "";
        while ((line = read.readLine()) != null) {
            outTemplate = outTemplate + line + System.getProperty("line.separator");
        }
        read.close();
        return outTemplate;
    }

    public void scheduleOutput(String filename, Context context) {
        this.scheduleOutput(filename, context, this.template);
    }

    public void scheduleOutput(String filename, Context context, String template) {
        OutputScheduler.getDefault().schedule(new VelocityRenderer(filename, context, template));
    }

    private final class VelocityRenderer
    implements Runnable {
        private final String filename;
        private final Context context;
        private final String template;

        private VelocityRenderer(String filename, Context context, String template) {
            this.filename = filename;
            this.context = context;
            this.template = template;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringWriter out = new StringWriter();
            try {
                VelocityEngine engine;
                VelocityEngine velocityEngine = engine = LocalSeismogramTemplateGenerator.getVelocity();
                synchronized (velocityEngine) {
                    VelocityContext tempContext = new VelocityContext(this.context);
                    tempContext.put("menu", (Object)AbstractVelocityStatus.this.renderedMenu);
                    engine.evaluate((Context)tempContext, (Writer)out, this.filename, this.template);
                }
                FileWritingTemplate.write(AbstractVelocityStatus.this.fileDir + "/" + this.filename, out.getBuffer().toString());
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle((Throwable)e);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof VelocityRenderer) {
                return ((VelocityRenderer)o).filename.equals(this.filename);
            }
            return false;
        }

        public int hashCode() {
            return this.filename.hashCode();
        }
    }
}

