/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.Fissures.seismogramDC.SeismogramAttrImpl;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import gov.usgs.earthworm.Menu;
import gov.usgs.earthworm.MenuItem;
import gov.usgs.earthworm.TraceBuf;
import gov.usgs.winston.server.WWSClient;
import java.util.ArrayList;
import java.util.List;

public class WinstonWaveServerSource
implements SeismogramSource {
    private WWSClient ws;

    public WinstonWaveServerSource(WWSClient ws) {
        this.ws = ws;
    }

    public static MicroSecondDate toDate(double d) {
        return new MicroSecondDate(Math.round(d * 1000000.0));
    }

    public static double toEpochSeconds(Time d) {
        return (double)new MicroSecondDate(d).getMicroSecondTime() / 1000000.0;
    }

    public static double toY2KSeconds(Time d) {
        return WinstonWaveServerSource.toY2KSeconds(new MicroSecondDate(d));
    }

    public static double toY2KSeconds(MicroSecondDate d) {
        return (double)d.getMicroSecondTime() / 1000000.0 - 9.46728E8;
    }

    public static MicroSecondDate y2kSecondsToDate(double d) {
        return WinstonWaveServerSource.toDate(d + 9.46728E8);
    }

    @Override
    public List<RequestFilter> available_data(List<RequestFilter> request) {
        ArrayList<RequestFilter> out = new ArrayList<RequestFilter>();
        for (RequestFilter rf : request) {
            Menu menu = this.ws.getMenuSCNL();
            for (int i = 0; i < menu.numItems(); ++i) {
                MicroSecondTimeRange rfRange;
                MicroSecondDate end;
                MicroSecondDate start;
                MicroSecondTimeRange menuRange;
                MenuItem item = menu.getItem(i);
                if (!item.getChannel().equals(rf.channel_id.channel_code) || !item.getStation().equals(rf.channel_id.station_code) || !item.getNetwork().equals(rf.channel_id.network_id.network_code) || !item.getLocation().equals(rf.channel_id.site_code) && (!item.getLocation().equals("--") || !rf.channel_id.site_code.equals("  ")) || !(menuRange = new MicroSecondTimeRange(start = WinstonWaveServerSource.toDate(item.getStartTime()), end = WinstonWaveServerSource.toDate(item.getEndTime()))).intersects(rfRange = new MicroSecondTimeRange(rf))) continue;
                MicroSecondTimeRange intersection = menuRange.intersection(rfRange);
                out.add(new RequestFilter(rf.channel_id, intersection.getBeginTime().getFissuresTime(), intersection.getEndTime().getFissuresTime()));
            }
        }
        return out;
    }

    @Override
    public List<LocalSeismogramImpl> retrieveData(List<RequestFilter> request) throws FissuresException {
        ArrayList<LocalSeismogramImpl> out = new ArrayList<LocalSeismogramImpl>();
        for (RequestFilter rf : request) {
            List traceBufs = this.ws.getTraceBufs(rf.channel_id.station_code, rf.channel_id.channel_code, rf.channel_id.network_id.network_code, rf.channel_id.site_code, WinstonWaveServerSource.toEpochSeconds(rf.start_time), WinstonWaveServerSource.toEpochSeconds(rf.end_time));
            if (traceBufs == null) continue;
            for (TraceBuf buf : traceBufs) {
                out.add(WinstonWaveServerSource.toFissures(buf, rf.channel_id));
            }
        }
        return out;
    }

    public static LocalSeismogramImpl toFissures(TraceBuf buf, ChannelId chan) {
        return new LocalSeismogramImpl((SeismogramAttr)new SeismogramAttrImpl("via WaveServer:" + Math.random(), WinstonWaveServerSource.toDate(buf.startTime).getFissuresTime(), buf.numSamples, (Sampling)new SamplingImpl(1, new TimeInterval(1.0 / buf.samplingRate, UnitImpl.SECOND)), (Unit)UnitImpl.COUNT, chan), buf.data);
    }
}

