/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.iris.Fissures.Error;
import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.Fissures.seismogramDC.RequestFilterUtil;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeSimpleDateFormat;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.mseed.FissuresConvert;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.dataSelectWS.DataSelectReader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.sod.BuildVersion;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.seismogram.MyAuthenticator;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import java.io.IOException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DataSelectWebService
implements SeismogramSourceLocator {
    protected int timeoutMillis;
    protected String baseUrl;
    public static final String DEFAULT_WS_URL = "http://www.iris.edu/ws/dataselect/query";
    public static ThreadSafeSimpleDateFormat longFormat = new ThreadSafeSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", TimeZone.getTimeZone("GMT"));
    private static final Logger logger = LoggerFactory.getLogger(DataSelectWebService.class);

    public DataSelectWebService(Element config) throws MalformedURLException {
        this(config, DEFAULT_WS_URL);
    }

    public DataSelectWebService(Element config, String defaultURL) throws MalformedURLException {
        this.baseUrl = SodUtil.loadText(config, "url", defaultURL);
        String user = SodUtil.loadText(config, "user", "");
        String password = SodUtil.loadText(config, "password", "");
        if (user.length() != 0 && password.length() != 0) {
            Authenticator.setDefault(new MyAuthenticator(user, password));
        }
        this.timeoutMillis = 1000 * SodUtil.loadInt(config, "timeoutSecs", 30);
    }

    @Override
    public SeismogramSource getSeismogramSource(CacheEvent event, ChannelImpl channel, RequestFilter[] infilters, CookieJar cookieJar) throws Exception {
        return new SeismogramSource(){

            @Override
            public List<RequestFilter> available_data(List<RequestFilter> request) {
                return request;
            }

            @Override
            public List<LocalSeismogramImpl> retrieveData(List<RequestFilter> request) throws FissuresException {
                try {
                    ArrayList<LocalSeismogramImpl> out = new ArrayList<LocalSeismogramImpl>();
                    DataSelectReader dsReader = new DataSelectReader(DataSelectWebService.this.baseUrl, DataSelectWebService.this.timeoutMillis);
                    dsReader.setUserAgent("SOD/" + BuildVersion.getVersion());
                    for (RequestFilter rf : request) {
                        MicroSecondDate start = new MicroSecondDate(rf.start_time);
                        List records = dsReader.read(rf.channel_id.network_id.network_code, rf.channel_id.station_code, rf.channel_id.site_code, rf.channel_id.channel_code, (Date)start, (Date)new MicroSecondDate(rf.end_time));
                        for (DataRecord dr : records) {
                            if (rf.channel_id.network_id.network_code.equals(dr.getHeader().getNetworkCode().trim()) && rf.channel_id.station_code.equals(dr.getHeader().getStationIdentifier().trim()) && rf.channel_id.site_code.equals(dr.getHeader().getLocationIdentifier().trim()) && rf.channel_id.channel_code.equals(dr.getHeader().getChannelIdentifier().trim())) continue;
                            throw new RuntimeException("Request: " + RequestFilterUtil.toString((RequestFilter)rf) + " did not return matching data: " + dr.toString());
                        }
                        List perRFList = FissuresConvert.toFissures((List)records);
                        for (LocalSeismogramImpl seis : perRFList) {
                            seis.channel_id.begin_time = rf.channel_id.begin_time;
                            seis.channel_id.network_id.begin_time = rf.channel_id.network_id.begin_time;
                        }
                        out.addAll(perRFList);
                    }
                    return out;
                }
                catch (IOException e) {
                    GlobalExceptionHandler.handle((Throwable)e);
                    throw new FissuresException(e.getMessage(), new Error(1, "IOException"));
                }
                catch (SeedFormatException e) {
                    GlobalExceptionHandler.handle((Throwable)e);
                    throw new FissuresException(e.getMessage(), new Error(1, "SeedFormatException"));
                }
                catch (SeisFileException e) {
                    GlobalExceptionHandler.handle((Throwable)e);
                    throw new FissuresException(e.getMessage(), new Error(1, "DataSelectException"));
                }
            }
        };
    }
}

