/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.source.network.WrappingNetworkSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class LoadedNetworkSource
extends WrappingNetworkSource
implements NetworkSource {
    StationImpl sta;
    List<? extends StationImpl> allStations;
    List<? extends ChannelImpl> chans = null;
    HashSet<String> instrumentationLoaded = new HashSet();

    public LoadedNetworkSource(NetworkSource wrapped, List<? extends StationImpl> allStations, StationImpl sta) {
        super(wrapped);
        this.sta = sta;
        this.allStations = allStations;
    }

    @Override
    public List<? extends ChannelImpl> getChannels(StationImpl station) {
        if (StationIdUtil.areEqual((Station)station, (Station)this.sta)) {
            if (this.chans == null) {
                this.chans = this.getWrapped().getChannels(this.sta);
            }
            ArrayList<? extends ChannelImpl> out = new ArrayList<ChannelImpl>();
            out.addAll(this.chans);
            return out;
        }
        return this.getWrapped().getChannels(station);
    }

    @Override
    public Instrumentation getInstrumentation(ChannelId chanId) throws ChannelNotFound, InvalidResponse {
        this.instrumentationLoaded.add(ChannelIdUtil.toString((ChannelId)chanId));
        return this.getWrapped().getInstrumentation(chanId);
    }

    @Override
    public QuantityImpl getSensitivity(ChannelId chanId) throws ChannelNotFound, InvalidResponse {
        this.instrumentationLoaded.add(ChannelIdUtil.toString((ChannelId)chanId));
        return this.getWrapped().getSensitivity(chanId);
    }

    @Override
    public List<? extends StationImpl> getStations(NetworkId net) {
        if (NetworkIdUtil.areEqual((NetworkId)net, (NetworkId)this.sta.getNetworkAttr().getId())) {
            return this.allStations;
        }
        return this.getWrapped().getStations(net);
    }

    public boolean isInstrumentationLoaded(ChannelId chan) {
        return this.instrumentationLoaded.contains(ChannelIdUtil.toString((ChannelId)chan));
    }
}

