/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import com.csvreader.CsvReader;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.SiteImpl;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheNetworkAccess;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.UserConfigurationException;
import edu.sc.seis.sod.source.AbstractCSVSource;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.subsetter.AreaSubsetter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;

public class CSVNetworkSource
extends AbstractCSVSource
implements NetworkSource {
    protected List<NetworkAttrImpl> networks;
    protected List<StationImpl> stations;
    protected List<ChannelImpl> channels;
    public static final String NET_CODE = "net.code";
    public static final String STATION_CODE = "station.code";
    public static final String SITE_CODE = "site.code";
    public static final String CODE = "code";
    public static final String NET_START = "net.start";
    public static final String NET_END = "net.end";
    public static final String SAMPLE_PERIOD = "sampling.period";
    public static final String SAMPLE_FREQUENCY = "sampling.frequency";
    public static final String START = "start";
    public static final String END = "end";
    public static final String OPERATOR = "operator";
    public static final String COMMENT = "comment";
    public static final String DESCRIPTION = "description";
    public static final String AZIMUTH = "azimuth";
    public static final String DIP = "dip";
    private static final String[] networkFields = new String[]{"net.code", "station.code", "site.code", "code", "longitude", "latitude", "elevation", "elevationUnits", "depth", "depthUnits", "sampling.period", "sampling.frequency", "net.start", "net.end", "start", "end", "name", "flinnEngdahlSeismicRegion", "flinnEngdahlGeographicRegion", "flinnEngdahlRegion", "flinnEngdahlRegionType", "azimuth", "dip", "operator", "comment", "description"};

    public CSVNetworkSource(Element config) throws ConfigurationException {
        this.initStations(config);
        this.initChannels(config);
    }

    protected void initStations(Element config) throws ConfigurationException {
        if (DOMHelper.hasElement((Element)config, (String)"stationFile")) {
            String filename;
            this.csvFilename = filename = DOMHelper.extractText((Element)config, (String)"stationFile");
            try {
                this.stations = this.getStationsFromReader(AreaSubsetter.makeRelativeOrRecipeDirReader(this.csvFilename));
            }
            catch (FileNotFoundException e) {
                throw new UserConfigurationException(e.getMessage() + " as a station CSV file.");
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to read " + this.csvFilename, e);
            }
        } else if (DOMHelper.hasElement((Element)config, (String)"stations")) {
            try {
                this.stations = this.getStationsFromReader(new StringReader(DOMHelper.extractText((Element)config, (String)"stations").trim()));
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to read stations from:" + DOMHelper.extractText((Element)config, (String)"stations"), e);
            }
        } else {
            throw new ConfigurationException("Can't find stationFile or stations in configuration.");
        }
        this.networks = this.getNetworksFromStations(this.stations);
    }

    protected void initChannels(Element config) throws ConfigurationException {
        if (DOMHelper.hasElement((Element)config, (String)"channelFile")) {
            String filename = DOMHelper.extractText((Element)config, (String)"channelFile");
            try {
                this.channels = this.getChannelsFromReader(AreaSubsetter.makeRelativeOrRecipeDirReader(filename), this.stations);
            }
            catch (FileNotFoundException e) {
                throw new UserConfigurationException(e.getMessage() + " as a channel CSV file.", e);
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to read " + filename, e);
            }
        } else if (DOMHelper.hasElement((Element)config, (String)"channels")) {
            try {
                this.channels = this.getChannelsFromReader(new StringReader(DOMHelper.extractText((Element)config, (String)"channels").trim()), this.stations);
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to read channels from:" + DOMHelper.extractText((Element)config, (String)"channels"), e);
            }
        } else {
            throw new ConfigurationException("Can't find channelFile or channels in configuration.");
        }
    }

    public CSVNetworkSource(String stationFile, String channelFile) throws ConfigurationException, FileNotFoundException, IOException {
        this.stations = this.getStationsFromReader(AreaSubsetter.makeRelativeOrRecipeDirReader(stationFile));
        this.channels = this.getChannelsFromReader(AreaSubsetter.makeRelativeOrRecipeDirReader(channelFile), this.stations);
    }

    public String getDescription() {
        return "CSVNetworkSource: " + this.csvFilename;
    }

    public List<NetworkAttrImpl> getNetworksFromStations(List<StationImpl> staList) {
        HashMap<String, NetworkAttrImpl> nets = new HashMap<String, NetworkAttrImpl>();
        for (StationImpl sta : staList) {
            nets.put(StationIdUtil.toStringNoDates((StationId)sta.getId()), new NetworkAttrImpl(sta.getId().network_id, "", "", ""));
        }
        ArrayList<NetworkAttrImpl> out = new ArrayList<NetworkAttrImpl>();
        for (NetworkAttrImpl net : nets.values()) {
            out.add(net);
        }
        return out;
    }

    public List<StationImpl> getStationsFromReader(Reader reader) throws IOException, FileNotFoundException, ConfigurationException {
        ArrayList<StationImpl> stations = new ArrayList<StationImpl>();
        CsvReader csvReader = new CsvReader(reader);
        List<String> headers = this.validateHeaders(csvReader);
        while (csvReader.readRecord()) {
            String netCode = csvReader.get(NET_CODE);
            String staCode = csvReader.get(CODE);
            float latitude = CSVNetworkSource.loadFloat(headers, csvReader, "latitude", 0.0f);
            float longitude = CSVNetworkSource.loadFloat(headers, csvReader, "longitude", 0.0f);
            double elevation = CSVNetworkSource.loadDouble(headers, csvReader, "elevation", 0.0);
            double depth = CSVNetworkSource.loadDouble(headers, csvReader, "depth", 0.0);
            UnitImpl elevationUnit = CSVNetworkSource.loadUnit(headers, csvReader, "elevationUnits", UnitImpl.METER);
            UnitImpl depthUnit = CSVNetworkSource.loadUnit(headers, csvReader, "depthUnits", UnitImpl.METER);
            Location location = new Location(latitude, longitude, (Quantity)new QuantityImpl(elevation, (Unit)elevationUnit), (Quantity)new QuantityImpl(depth, (Unit)depthUnit), LocationType.GEOGRAPHIC);
            NetworkId netId = new NetworkId(netCode, CSVNetworkSource.loadTime(headers, csvReader, NET_START, DEFAULT_TIME));
            Time staBegin = CSVNetworkSource.loadTime(headers, csvReader, START, DEFAULT_TIME);
            StationId staId = new StationId(netId, staCode, staBegin);
            StationImpl station = new StationImpl(staId, CSVNetworkSource.loadString(headers, csvReader, "name", ""), location, CSVNetworkSource.loadString(headers, csvReader, OPERATOR, ""), CSVNetworkSource.loadString(headers, csvReader, DESCRIPTION, ""), CSVNetworkSource.loadString(headers, csvReader, COMMENT, ""), (NetworkAttr)new NetworkAttrImpl(netId, "", "", ""));
            stations.add(station);
        }
        return stations;
    }

    protected StationImpl getStationForChannel(String netCode, String staCode) {
        for (StationImpl stationImpl : this.stations) {
            if (!netCode.equals(stationImpl.getNetworkAttrImpl().get_code()) || !staCode.equals(stationImpl.get_code())) continue;
            return stationImpl;
        }
        return null;
    }

    public List<ChannelImpl> getChannelsFromReader(Reader reader, List<StationImpl> stations) throws IOException, FileNotFoundException, ConfigurationException {
        ArrayList<ChannelImpl> channels = new ArrayList<ChannelImpl>();
        CsvReader csvReader = new CsvReader(reader);
        List<String> headers = this.validateHeaders(csvReader);
        while (csvReader.readRecord()) {
            Location location;
            String netCode = csvReader.get(NET_CODE);
            String staCode = csvReader.get(STATION_CODE);
            String siteCode = csvReader.get(SITE_CODE);
            String chanCode = csvReader.get(CODE);
            StationImpl curStation = this.getStationForChannel(netCode, staCode);
            if (curStation == null) {
                throw new UserConfigurationException("Station " + netCode + "." + staCode + " is not a known station. Add it to the stations section.");
            }
            if (headers.contains("latitude") || headers.contains("longitude") || headers.contains("elevation") || headers.contains("depth")) {
                float latitude = CSVNetworkSource.loadFloat(headers, csvReader, "latitude", 0.0f);
                float longitude = CSVNetworkSource.loadFloat(headers, csvReader, "longitude", 0.0f);
                double elevation = CSVNetworkSource.loadDouble(headers, csvReader, "elevation", 0.0);
                double depth = CSVNetworkSource.loadDouble(headers, csvReader, "depth", 0.0);
                UnitImpl elevationUnit = CSVNetworkSource.loadUnit(headers, csvReader, "elevationUnits", UnitImpl.METER);
                UnitImpl depthUnit = CSVNetworkSource.loadUnit(headers, csvReader, "depthUnits", UnitImpl.METER);
                location = new Location(latitude, longitude, (Quantity)new QuantityImpl(elevation, (Unit)elevationUnit), (Quantity)new QuantityImpl(depth, (Unit)depthUnit), LocationType.GEOGRAPHIC);
            } else {
                location = curStation.getLocation();
            }
            Time chanBegin = CSVNetworkSource.loadTime(headers, csvReader, START, DEFAULT_TIME);
            float azimuth = CSVNetworkSource.loadFloat(headers, csvReader, AZIMUTH, ChannelImpl.getAzimuth((String)chanCode));
            float dip = CSVNetworkSource.loadFloat(headers, csvReader, DIP, ChannelImpl.getDip((String)chanCode));
            SamplingImpl sampling = headers.contains(SAMPLE_PERIOD) ? new SamplingImpl(1, new TimeInterval((double)CSVNetworkSource.loadFloat(headers, csvReader, SAMPLE_PERIOD, 1.0f), UnitImpl.SECOND)) : (headers.contains(SAMPLE_PERIOD) ? new SamplingImpl(1, new TimeInterval((double)(1.0f / CSVNetworkSource.loadFloat(headers, csvReader, SAMPLE_FREQUENCY, 1.0f)), UnitImpl.SECOND)) : new SamplingImpl(1, new TimeInterval(1.0, UnitImpl.SECOND)));
            TimeRange chanTime = new TimeRange(chanBegin, CSVNetworkSource.loadTime(headers, csvReader, END, DEFAULT_END));
            ChannelImpl channel = new ChannelImpl(new ChannelId(curStation.get_id().network_id, staCode, siteCode, chanCode, chanBegin), CSVNetworkSource.loadString(headers, csvReader, "name", ""), new Orientation(azimuth, dip), (Sampling)sampling, chanTime, (Site)new SiteImpl(new SiteId(curStation.get_id().network_id, staCode, siteCode, chanBegin), location, (Station)curStation, ""));
            channels.add(channel);
        }
        return channels;
    }

    public String toString() {
        return "CSVNetworkSource using " + this.csvFilename;
    }

    @Override
    public List<? extends ChannelImpl> getChannels(StationImpl station) {
        ArrayList<ChannelImpl> out = new ArrayList<ChannelImpl>();
        for (ChannelImpl chan : this.channels) {
            if (!StationIdUtil.areEqual((StationId)station.getId(), (StationId)chan.getStationImpl().getId())) continue;
            out.add(chan);
        }
        return out;
    }

    @Override
    public Instrumentation getInstrumentation(ChannelId chanId) throws ChannelNotFound, InvalidResponse {
        throw new ChannelNotFound();
    }

    @Override
    public CacheNetworkAccess getNetwork(NetworkAttrImpl attr) {
        return new CacheNetworkAccess(null, attr);
    }

    @Override
    public List<? extends CacheNetworkAccess> getNetworkByName(String name) throws NetworkNotFound {
        throw new NetworkNotFound();
    }

    @Override
    public List<? extends NetworkAttrImpl> getNetworks() {
        return Collections.unmodifiableList(this.networks);
    }

    @Override
    public QuantityImpl getSensitivity(ChannelId chanId) throws ChannelNotFound, InvalidResponse {
        throw new ChannelNotFound();
    }

    @Override
    public List<? extends StationImpl> getStations(NetworkId net) {
        ArrayList<StationImpl> staList = new ArrayList<StationImpl>();
        for (StationImpl sta : this.stations) {
            if (!NetworkIdUtil.areEqual((NetworkId)net, (NetworkId)sta.getId().network_id)) continue;
            staList.add(sta);
        }
        return staList;
    }

    @Override
    public String[] getFields() {
        return networkFields;
    }

    @Override
    public TimeInterval getRefreshInterval() {
        return new TimeInterval(0.0, UnitImpl.MILLISECOND);
    }

    @Override
    public String getDNS() {
        if (this.csvFilename != null && this.csvFilename.length() != 0) {
            return this.csvFilename;
        }
        return "inline";
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }
}

