/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheNetworkAccess;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.AbstractSource;
import edu.sc.seis.sod.source.network.NetworkSource;
import java.util.List;
import org.w3c.dom.Element;

public abstract class AbstractNetworkSource
extends AbstractSource
implements NetworkSource {
    protected TimeInterval refreshInterval;
    public static final String REFRESH_ELEMENT = "refreshInterval";

    public AbstractNetworkSource(String dns, String name, int retries) {
        super(dns, name, retries);
        this.refreshInterval = new TimeInterval(1.0, UnitImpl.FORTNIGHT);
    }

    public AbstractNetworkSource(AbstractNetworkSource wrapped) {
        this(wrapped.getDNS(), wrapped.getName(), wrapped.getRetries());
    }

    public AbstractNetworkSource(Element config) throws Exception {
        super(config, "IRIS_NetworkDC");
        Element subElement = SodUtil.getElement(config, REFRESH_ELEMENT);
        this.refreshInterval = subElement != null ? SodUtil.loadTimeInterval(subElement) : new TimeInterval(1.0, UnitImpl.FORTNIGHT);
    }

    @Override
    public TimeInterval getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public abstract CacheNetworkAccess getNetwork(NetworkAttrImpl var1);

    @Override
    public abstract List<? extends CacheNetworkAccess> getNetworkByName(String var1) throws NetworkNotFound;

    @Override
    public abstract List<? extends NetworkAttrImpl> getNetworks();

    @Override
    public abstract List<? extends StationImpl> getStations(NetworkId var1);

    @Override
    public abstract List<? extends ChannelImpl> getChannels(StationImpl var1);

    @Override
    public abstract QuantityImpl getSensitivity(ChannelId var1) throws ChannelNotFound, InvalidResponse;

    @Override
    public abstract Instrumentation getInstrumentation(ChannelId var1) throws ChannelNotFound, InvalidResponse;
}

