/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.source.event.EventSource;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleEventSource
implements EventSource {
    public boolean hasNextBeenCalled = false;
    private static final Logger logger = LoggerFactory.getLogger(SimpleEventSource.class);

    public abstract CacheEvent[] getEvents();

    @Override
    public boolean hasNext() {
        return !this.hasNextBeenCalled;
    }

    @Override
    public CacheEvent[] next() {
        this.hasNextBeenCalled = true;
        CacheEvent[] out = this.getEvents();
        logger.debug("returning " + out.length + " events");
        return out;
    }

    @Override
    public TimeInterval getWaitBeforeNext() {
        return new TimeInterval(0.0, UnitImpl.SECOND);
    }

    @Override
    public MicroSecondTimeRange getEventTimeRange() {
        MicroSecondDate earliest;
        CacheEvent[] events = this.getEvents();
        MicroSecondDate latest = earliest = this.extractBeginTime(events[0]);
        for (int i = 0; i < events.length; ++i) {
            MicroSecondDate eventTime = this.extractBeginTime(events[i]);
            if (eventTime.before((Date)earliest)) {
                earliest = eventTime;
                continue;
            }
            if (!eventTime.after((Date)latest)) continue;
            latest = eventTime;
        }
        return new MicroSecondTimeRange(earliest, latest);
    }

    public MicroSecondDate extractBeginTime(CacheEvent ev) {
        return new MicroSecondDate(ev.getOrigin().getOriginTime());
    }
}

