/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.iris.Fissures.IfEvent.Magnitude;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.mockFissures.IfEvent.MockEventAttr;
import edu.sc.seis.fissuresUtil.mockFissures.IfEvent.MockOrigin;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.event.PeriodicFakeEventSource;
import java.util.Date;
import org.w3c.dom.Element;

public class NowFakeEventSource
extends PeriodicFakeEventSource {
    public NowFakeEventSource(Element config) throws ConfigurationException {
        super(ClockUtil.now(), SodUtil.loadTimeInterval(SodUtil.getElement(config, "interval")), SodUtil.loadInt(config, "numEvents", -1));
    }

    @Override
    public String getDescription() {
        return "Events starting now, with " + this.numEvents + " new events at the current request time but no more frequent than " + this.interval;
    }

    @Override
    public MicroSecondTimeRange getEventTimeRange() {
        return new MicroSecondTimeRange(this.startTime, ClockUtil.wayFuture());
    }

    @Override
    public CacheEvent[] next() {
        if (this.nextEventTime.before((Date)ClockUtil.now())) {
            ++this.eventCounter;
            this.prevEventTime = ClockUtil.now();
            this.nextEventTime = this.prevEventTime.add(this.interval);
            return new CacheEvent[]{new CacheEvent(MockEventAttr.create((int)-1), MockOrigin.create((MicroSecondDate)this.prevEventTime, (Magnitude[])mags))};
        }
        return new CacheEvent[0];
    }
}

