/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.EventChannelPair;
import edu.sc.seis.sod.EventNetworkPair;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.Stage;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class WaveformCountProcessor
implements WaveformMonitor {
    private static final String WAVEFORM_FILE = "waveforms.txt";
    int waveformCounter = this.getNumWaveforms("waveforms.txt");
    private static final String description = "Number of Waveforms processed = ";

    public WaveformCountProcessor(Element config) throws IOException {
    }

    @Override
    public void update(EventNetworkPair ecp) {
    }

    @Override
    public void update(EventStationPair ecp) {
    }

    @Override
    public void update(EventChannelPair ecp) {
        Status processorSuccess = Status.get(Stage.PROCESSOR, Standing.SUCCESS);
        if (ecp.getStatus() == processorSuccess) {
            ++this.waveformCounter;
            this.writeOutput();
        }
    }

    @Override
    public void update(EventVectorPair ecp) {
        Status processorSuccess = Status.get(Stage.PROCESSOR, Standing.SUCCESS);
        if (ecp.getStatus() == processorSuccess) {
            ++this.waveformCounter;
            this.writeOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeOutput() {
        try {
            File actualOutputLocation = new File(WAVEFORM_FILE).getCanonicalFile();
            actualOutputLocation.getParentFile().mkdirs();
            File temp = File.createTempFile(actualOutputLocation.getName(), null, actualOutputLocation.getParentFile());
            BufferedWriter fileWriter = null;
            try {
                fileWriter = new BufferedWriter(new FileWriter(temp));
                fileWriter.write(description + this.waveformCounter);
            }
            finally {
                fileWriter.close();
            }
            actualOutputLocation.delete();
            temp.renameTo(actualOutputLocation);
        }
        catch (IOException ie) {
            GlobalExceptionHandler.handle((String)"problem writing the waveformCount into file ", (Throwable)ie);
        }
    }

    private int getNumWaveforms(String fileName) throws IOException {
        File f = new File(fileName);
        if (f.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            StringTokenizer line = new StringTokenizer(reader.readLine());
            StringTokenizer descTokenizer = new StringTokenizer(description);
            int tokenCnt = descTokenizer.countTokens();
            String numWaveforms = null;
            for (int i = 0; i <= tokenCnt; ++i) {
                numWaveforms = line.nextToken();
            }
            return Integer.parseInt(numWaveforms);
        }
        return 0;
    }
}

