/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.gmt.GenericCommandExecute;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.process.waveform.AbstractSeismogramWriter;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SacExecute
implements WaveformProcess {
    protected VelocityEngine ve;
    private String application;
    private String commands;
    private String prefix;
    private GenericCommandExecute externalApp;
    private boolean sacAlive = false;
    PipedReader reader;
    PipedWriter writer;
    PipedWriter stdout;
    PipedWriter stderr;
    PipedReader stdOutReader;
    PipedReader stdErrReader;
    String stdoutBuffer = "";
    String stderrBuffer = "";
    private static final Logger logger = LoggerFactory.getLogger(SacExecute.class);

    public SacExecute(Element el) throws Exception {
        this.application = DOMHelper.extractText((Element)el, (String)"application", (String)"sac");
        this.commands = DOMHelper.extractText((Element)el, (String)"commands", (String)"");
        this.prefix = DOMHelper.extractText((Element)el, (String)"prefix", (String)"");
        this.writer = new PipedWriter(new PipedReader());
        this.stdout = new PipedWriter(new PipedReader());
        this.stderr = new PipedWriter(new PipedReader());
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SacExecute.this.sacAlive = true;
                    int exitValue = GenericCommandExecute.execute((String)SacExecute.this.application, (Reader)SacExecute.this.reader, (Writer)SacExecute.this.stdout, (Writer)SacExecute.this.stderr);
                    SacExecute.this.sacAlive = false;
                    logger.info("SacExecute exit value is: " + exitValue);
                }
                catch (Throwable e) {
                    GlobalExceptionHandler.handle((Throwable)e);
                }
            }
        }, "SacExecute");
        t.setDaemon(true);
        t.start();
        this.expect("SAC>");
        this.ve = new VelocityEngine();
        Properties props = new Properties();
        SimpleVelocitizer.setupVelocityLogger(props, logger);
        this.ve.init(props);
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        String line;
        String files = "";
        for (int i = 0; i < seismograms.length; ++i) {
            files = files + " " + (String)cookieJar.get(AbstractSeismogramWriter.getCookieName(this.prefix, channel.get_id(), i));
        }
        VelocityContext context = new VelocityContext();
        context.put("files", (Object)files);
        StringWriter buffer = new StringWriter();
        this.ve.evaluate((Context)context, (Writer)buffer, "SacExecute", this.commands);
        BufferedReader readBuffer = new BufferedReader(new StringReader(buffer.getBuffer().toString()));
        while ((line = readBuffer.readLine()) != null) {
            this.send(line.trim());
            this.expect("SAC>");
        }
        return new WaveformResult(seismograms, new StringTreeLeaf(this, true));
    }

    private void expect(String response) throws IOException {
        System.err.println("Expecting: " + response);
        int index = this.stdoutBuffer.indexOf(response);
        char[] cbuf = new char[100];
        while (index == -1) {
            String prior;
            System.out.println("Waiting on read...");
            if (!this.sacAlive) {
                throw new IOException("Application " + this.application + " has exited");
            }
            if (this.stdOutReader.ready()) {
                int numRead = this.stdOutReader.read(cbuf);
                this.stdoutBuffer = this.stdoutBuffer + new String(cbuf, 0, numRead);
                System.err.println("Does '" + this.stdoutBuffer + "' match '" + response + "'?");
                index = this.stdoutBuffer.indexOf(response);
                prior = this.stdoutBuffer.substring(0, index + response.length());
                System.out.println("Match: " + prior);
                this.stdoutBuffer = this.stdoutBuffer.substring(index + response.length());
                System.out.println("Buffer: " + this.stdoutBuffer);
            } else if (this.stdErrReader.ready()) {
                int numRead = this.stdErrReader.read(cbuf);
                this.stderrBuffer = this.stderrBuffer + new String(cbuf, 0, numRead);
                System.err.println("Does stderr '" + this.stderrBuffer + "' match '" + response + "'?");
                index = this.stderrBuffer.indexOf(response);
                prior = this.stderrBuffer.substring(0, index + response.length());
                System.out.println("Match: " + prior);
                this.stderrBuffer = this.stderrBuffer.substring(index + response.length());
                System.out.println("Buffer: " + this.stderrBuffer);
            }
            if (index != -1) {
                System.err.println("Yes.");
            } else {
                System.err.println("No.");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
    }

    private void send(String cmd) throws IOException {
        System.err.println("Sending: " + cmd);
        this.writer.write(cmd + "\n");
    }

    protected void finalize() throws Throwable {
        this.send("q");
        super.finalize();
    }
}

