/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.LongShortTrigger;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.display.RecordSectionDisplay;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.display.configuration.SeismogramDisplayConfiguration;
import edu.sc.seis.fissuresUtil.display.registrar.CustomLayOutConfig;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutConfig;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.hibernate.EventSeismogramFileReference;
import edu.sc.seis.fissuresUtil.hibernate.NetworkDB;
import edu.sc.seis.fissuresUtil.hibernate.SeismogramFileRefDB;
import edu.sc.seis.fissuresUtil.time.ReduceTool;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSet;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.URLDataSetSeismogram;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.LocalSeismogramArm;
import edu.sc.seis.sod.MotionVectorArm;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.RecordSectionItem;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.process.waveform.AbstractSeismogramWriter;
import edu.sc.seis.sod.process.waveform.RSDistanceRange;
import edu.sc.seis.sod.process.waveform.RecordSectionSpacer;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.eventChannel.EventChannelLogicalSubsetter;
import edu.sc.seis.sod.subsetter.eventChannel.EventChannelSubsetter;
import edu.sc.seis.sod.subsetter.eventChannel.PassEventChannel;
import edu.sc.seis.sod.subsetter.requestGenerator.vector.RequestGeneratorWrapper;
import edu.sc.seis.sod.subsetter.requestGenerator.vector.VectorRequestGenerator;
import java.awt.Dimension;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class RSChannelInfoPopulator
implements WaveformProcess {
    public static final String GENS_POPS_XPATH = "//recordSectionDisplayGenerator | //RSChannelInfoPopulator | //externalWaveformProcess[classname/text() = \"edu.sc.seis.rev.map.RecordSectionAndMapGenerator\"]";
    private AbstractSeismogramWriter saveSeisToFile;
    private String orientationId;
    private String saveSeisId;
    private String recordSectionId;
    private RSDistanceRange distRange;
    private double percentSeisHeight = 10.0;
    private Dimension recSecDim = new Dimension(500, 500);
    protected RecordSectionSpacer spacer;
    private SeismogramDisplayConfiguration displayCreator;
    private EventChannelSubsetter channelAcceptor;
    private static CacheEvent lastEvent = null;
    private static List<URLDataSetSeismogram> lastDSS = new ArrayList<URLDataSetSeismogram>();
    private static final Logger logger = LoggerFactory.getLogger(RSChannelInfoPopulator.class);

    public RSChannelInfoPopulator(Element config) throws Exception {
        this.initConfig(config);
        this.saveSeisToFile = RSChannelInfoPopulator.getSeismogramWriter(this.saveSeisId);
    }

    private void initConfig(Element config) throws NoSuchFieldException, ConfigurationException {
        this.orientationId = SodUtil.getText(SodUtil.getElement(config, "orientationId"));
        this.recordSectionId = SodUtil.getText(SodUtil.getElement(config, "recordSectionId"));
        this.saveSeisId = DOMHelper.extractText((Element)config, (String)"writerName", (String)this.orientationId);
        this.channelAcceptor = DOMHelper.hasElement((Element)config, (String)"eventChannelSubsetter") ? EventChannelLogicalSubsetter.createSubsetter((Subsetter)SodUtil.load(SodUtil.getFirstEmbeddedElement(SodUtil.getElement(config, "eventChannelSubsetter")), EventChannelLogicalSubsetter.packages)) : new PassEventChannel();
        if (DOMHelper.hasElement((Element)config, (String)"percentSeisHeight")) {
            this.percentSeisHeight = new Double(SodUtil.getText(SodUtil.getElement(config, "percentSeisHeight")));
        }
        int idealNumberOfSeismograms = 10;
        if (DOMHelper.hasElement((Element)config, (String)"idealNumberOfSeismograms")) {
            String idealNumText = SodUtil.getText(SodUtil.getElement(config, "idealNumberOfSeismograms"));
            idealNumberOfSeismograms = new Integer(idealNumText);
        }
        int maxNumberOfSeismograms = idealNumberOfSeismograms + 5;
        if (DOMHelper.hasElement((Element)config, (String)"maxNumberOfSeismograms")) {
            String maxSeisText = SodUtil.getText(SodUtil.getElement(config, "maximumSeismogramsPerRecordSection"));
            maxNumberOfSeismograms = new Integer(maxSeisText);
        }
        if (DOMHelper.hasElement((Element)config, (String)"distanceRange")) {
            this.distRange = new RSDistanceRange(SodUtil.getElement(config, "distanceRange"));
        }
        if (DOMHelper.hasElement((Element)config, (String)"recordSectionSize")) {
            int width = new Integer(SodUtil.getText(SodUtil.getElement(SodUtil.getElement(config, "recordSectionSize"), "width")));
            int height = new Integer(SodUtil.getText(SodUtil.getElement(SodUtil.getElement(config, "recordSectionSize"), "height")));
            this.recSecDim = new Dimension(width, height);
        }
        if (this.distRange != null) {
            this.spacer = new RecordSectionSpacer(this.distRange, idealNumberOfSeismograms, maxNumberOfSeismograms);
        }
        if (DOMHelper.hasElement((Element)config, (String)"displayConfig")) {
            this.displayCreator = SeismogramDisplayConfiguration.create((Element)DOMHelper.getElement((Element)config, (String)"displayConfig"));
        }
    }

    public Dimension getRecSecDimension() {
        return this.recSecDim;
    }

    public AbstractSeismogramWriter getSeismogramWriter() throws Exception {
        return this.saveSeisToFile;
    }

    public static AbstractSeismogramWriter getSeismogramWriter(String saveId) throws Exception {
        String xpath = "//mseedWriter[name/text() = \"" + saveId + "\"] | " + "//sacWriter[name/text() = \"" + saveId + "\"]";
        return RSChannelInfoPopulator.extractSaveSeis(xpath, "No Writer element with writerName " + saveId + " found");
    }

    private static AbstractSeismogramWriter extractSaveSeis(String xpath, String errorMsgIfNotFound) throws ConfigurationException {
        Element saveSeisConf = DOMHelper.extractElement((Element)Start.getConfig(), (String)xpath);
        if (saveSeisConf == null) {
            throw new ConfigurationException(errorMsgIfNotFound);
        }
        return (AbstractSeismogramWriter)SodUtil.load(saveSeisConf, "waveform");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemoryDataSetSeismogram> getDSSForRecordSectionItems(List<RecordSectionItem> rsList, CacheEvent event) throws Exception {
        MemoryDataSet dataSet = new MemoryDataSet("tmp", "tmp", "tmp", new AuditInfo[0]);
        dataSet.addParameter("edu.sc.seis.fissuresUtil.xml#EVENT", (Object)event, new AuditInfo[0]);
        ArrayList<MemoryDataSetSeismogram> out = new ArrayList<MemoryDataSetSeismogram>();
        for (RecordSectionItem rsi : rsList) {
            RSChannelInfoPopulator rSChannelInfoPopulator = this;
            synchronized (rSChannelInfoPopulator) {
                URLDataSetSeismogram dss = RSChannelInfoPopulator.extractSeismogramsFromDB(rsi);
                out.add(new MemoryDataSetSeismogram(dss.getSeismograms(), (DataSet)dataSet, dss.getName(), dss.getRequestFilter()));
                dataSet.addParameter("edu.sc.seis.fissuresUtil.xml#CHANNEL_", (Object)rsi.getChannel(), new AuditInfo[0]);
            }
        }
        return out;
    }

    public List<MemoryDataSetSeismogram> wrap(List<? extends DataSetSeismogram> dss) throws Exception {
        ArrayList<MemoryDataSetSeismogram> memDss = new ArrayList<MemoryDataSetSeismogram>(dss.size());
        for (DataSetSeismogram dataSetSeismogram : dss) {
            try {
                memDss.add(new MemoryDataSetSeismogram(((URLDataSetSeismogram)dataSetSeismogram).getSeismograms(), dataSetSeismogram.getDataSet(), dataSetSeismogram.getName(), dataSetSeismogram.getRequestFilter()));
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle((String)("Error loading seismogram, skipping. " + dataSetSeismogram), (Throwable)e);
            }
        }
        return memDss;
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl chan, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        List<RecordSectionItem> best = this.updateTable(event, chan, original, available, seismograms, cookieJar);
        boolean out = best.size() != 0;
        return new WaveformResult(seismograms, new StringTreeLeaf(this, out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecordSectionItem> updateTable(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        SodDB soddb;
        RecordSectionItem current;
        if (!this.channelAcceptor.accept(event, channel, cookieJar).isSuccess()) {
            return new ArrayList<RecordSectionItem>();
        }
        if (this.orientationId.equals("main") && !channel.get_code().endsWith("Z")) {
            throw new Exception("Try to put non-Z channel in main record section: " + ChannelIdUtil.toStringNoDates((Channel)channel));
        }
        RSChannelInfoPopulator rSChannelInfoPopulator = this;
        synchronized (rSChannelInfoPopulator) {
            URLDataSetSeismogram chanDSS = SeismogramFileRefDB.getSingleton().getDataSetSeismogram(channel.get_id(), event, ReduceTool.cover((RequestFilter[])original));
            URLDataSetSeismogram[] dss = RSChannelInfoPopulator.addToCache(event, channel, chanDSS).toArray(new URLDataSetSeismogram[0]);
        }
        float ston = 0.0f;
        Object[] cookieKeys = cookieJar.getKeys();
        for (int i = 0; i < cookieKeys.length; ++i) {
            if (!(cookieKeys[i] instanceof String) || !((String)cookieKeys[i]).startsWith("sod_phaseStoN_")) continue;
            ston = ((LongShortTrigger)cookieJar.get((String)cookieKeys[i])).getValue();
            break;
        }
        if ((current = (soddb = SodDB.getSingleton()).getRecordSectionItem(this.orientationId, this.recordSectionId, event, channel)) == null) {
            current = new RecordSectionItem(this.orientationId, this.recordSectionId, event, (Channel)channel, ston, false);
            soddb.put(current);
        }
        List<RecordSectionItem> bestRSList = soddb.getBestForRecordSection(this.orientationId, this.recordSectionId, event);
        List<RecordSectionItem> newBestRSList = this.spacer.spaceOut(soddb.getRecordSectionItemList(this.orientationId, this.recordSectionId, event));
        if (newBestRSList.contains(current)) {
            if (newBestRSList.size() <= bestRSList.size()) {
                List<RecordSectionItem> allRSI = soddb.getRecordSectionItemList(this.orientationId, this.recordSectionId, event);
                newBestRSList = this.spacer.spaceOut(bestRSList);
                ArrayList<RecordSectionItem> needUpdate = new ArrayList<RecordSectionItem>();
                for (RecordSectionItem rsi : allRSI) {
                    if (!rsi.isInBest() || newBestRSList.contains(rsi)) continue;
                    rsi.setInBest(false);
                    needUpdate.add(rsi);
                }
                for (RecordSectionItem rsi : newBestRSList) {
                    if (rsi.isInBest()) continue;
                    rsi.setInBest(true);
                    needUpdate.add(rsi);
                }
                for (RecordSectionItem rsi : needUpdate) {
                    soddb.getSession().update((Object)rsi);
                }
            } else {
                current.setInBest(true);
                soddb.getSession().update((Object)current);
            }
            return newBestRSList;
        }
        return new ArrayList<RecordSectionItem>();
    }

    public ChannelId[] getChannelIds(List<DataSetSeismogram> dss) throws SQLException, NotFound {
        ChannelId[] channelIds = new ChannelId[dss.size()];
        for (int j = 0; j < dss.size(); ++j) {
            channelIds[j] = dss.get((int)j).getRequestFilter().channel_id;
        }
        return channelIds;
    }

    public List<URLDataSetSeismogram> extractSeismograms(CacheEvent event) throws Exception {
        List<URLDataSetSeismogram> copy = RSChannelInfoPopulator.extractSeismogramsFromDB(event);
        ArrayList<URLDataSetSeismogram> out = new ArrayList<URLDataSetSeismogram>();
        for (URLDataSetSeismogram urlDSS : copy) {
            if (!this.channelAcceptor.accept(event, (ChannelImpl)urlDSS.getChannel(), new CookieJar()).isSuccess()) continue;
            out.add(urlDSS);
        }
        return out;
    }

    private static synchronized List<URLDataSetSeismogram> addToCache(CacheEvent event, ChannelImpl chan, URLDataSetSeismogram dss) throws Exception {
        RSChannelInfoPopulator.extractSeismogramsFromDB(event);
        lastDSS.get(0).getDataSet().addDataSetSeismogram((DataSetSeismogram)dss, new AuditInfo[0]);
        dss.getDataSet().addParameter("edu.sc.seis.fissuresUtil.xml#CHANNEL_", (Object)chan, new AuditInfo[0]);
        lastDSS.add(dss);
        return RSChannelInfoPopulator.extractSeismogramsFromDB(event);
    }

    private static synchronized List<URLDataSetSeismogram> extractSeismogramsFromDB(CacheEvent event) throws Exception {
        if (lastDSS.size() == 0 || lastEvent.getDbid() != event.getDbid()) {
            logger.debug("Not a repeat event, getting dss from db. lastEvent=" + lastEvent + "  newEvent=" + event);
            List seisFileRefs = SeismogramFileRefDB.getSingleton().getSeismogramsForEvent(event);
            MemoryDataSet ds = new MemoryDataSet("fake id", "temp name", "RSChannelInfoPopulator", new AuditInfo[0]);
            ds.addParameter("edu.sc.seis.fissuresUtil.xml#EVENT", (Object)event, new AuditInfo[0]);
            ArrayList<URLDataSetSeismogram> dssList = new ArrayList<URLDataSetSeismogram>();
            for (EventSeismogramFileReference esRef : seisFileRefs) {
                try {
                    ChannelImpl chan = NetworkDB.getSingleton().getChannel(esRef.getNetworkCode(), esRef.getStationCode(), esRef.getSiteCode(), esRef.getChannelCode(), new MicroSecondDate(esRef.getBeginTime()));
                    RequestFilter[] rf = null;
                    if (Start.getWaveformRecipe() instanceof LocalSeismogramArm) {
                        rf = ((LocalSeismogramArm)Start.getWaveformRecipe()).getRequestGenerator().generateRequest(event, chan, null);
                    } else {
                        VectorRequestGenerator vrg = ((MotionVectorArm)Start.getWaveformRecipe()).getRequestGenerator();
                        if (vrg instanceof RequestGeneratorWrapper) {
                            rf = ((RequestGeneratorWrapper)vrg).getRequestGenerator().generateRequest(event, chan, null);
                        }
                    }
                    URLDataSetSeismogram dss = esRef.getDataSetSeismogram((DataSet)ds, ReduceTool.cover((RequestFilter[])rf));
                    dssList.add(dss);
                    ds.addParameter("edu.sc.seis.fissuresUtil.xml#CHANNEL_", (Object)chan, new AuditInfo[0]);
                }
                catch (NotFound e) {
                    logger.error("no channel in dataset for id=" + esRef.getNetworkCode() + "." + esRef.getStationCode() + "." + esRef.getSiteCode() + "." + esRef.getChannelCode() + " even though seismogram is in dataset. Skipping this seismogram.");
                }
            }
            lastEvent = event;
            lastDSS = dssList;
        }
        ArrayList<URLDataSetSeismogram> copy = new ArrayList<URLDataSetSeismogram>(lastDSS.size());
        copy.addAll(lastDSS);
        return copy;
    }

    public static URLDataSetSeismogram extractSeismogramsFromDB(RecordSectionItem rsi) throws Exception {
        MemoryDataSet ds = new MemoryDataSet("fake id", "temp name", "RSChannelInfoPopulator", new AuditInfo[0]);
        ds.addParameter("edu.sc.seis.fissuresUtil.xml#EVENT", (Object)rsi.getEvent(), new AuditInfo[0]);
        ds.addParameter("edu.sc.seis.fissuresUtil.xml#CHANNEL_", (Object)rsi.getChannel(), new AuditInfo[0]);
        RequestFilter[] rf = null;
        if (Start.getWaveformRecipe() == null) {
            throw new ConfigurationException("WaveformArm is NULL");
        }
        if (Start.getWaveformRecipe() instanceof LocalSeismogramArm) {
            rf = ((LocalSeismogramArm)Start.getWaveformRecipe()).getRequestGenerator().generateRequest(rsi.getEvent(), (ChannelImpl)rsi.getChannel(), null);
        } else {
            VectorRequestGenerator vrg = ((MotionVectorArm)Start.getWaveformRecipe()).getRequestGenerator();
            if (vrg instanceof RequestGeneratorWrapper) {
                rf = ((RequestGeneratorWrapper)vrg).getRequestGenerator().generateRequest(rsi.getEvent(), (ChannelImpl)rsi.getChannel(), null);
            }
        }
        return SeismogramFileRefDB.getSingleton().getDataSetSeismogram(rsi.getChannel().getId(), rsi.getEvent(), ReduceTool.cover((RequestFilter[])rf));
    }

    public RecordSectionDisplay getConfiguredRSDisplay() {
        RecordSectionDisplay rsDisplay = (RecordSectionDisplay)this.displayCreator.createDisplay();
        if (this.distRange != null) {
            CustomLayOutConfig custConfig = new CustomLayOutConfig(this.distRange.getMinDistance(), this.distRange.getMaxDistance(), this.percentSeisHeight);
            custConfig.setSwapAxes(rsDisplay.getSwapAxes());
            rsDisplay.setLayout((LayoutConfig)custConfig);
        }
        return rsDisplay;
    }

    public static ChannelId getMatchingChanIdIgnoreDates(ChannelId chan, ChannelId[] channels) {
        for (int i = 0; i < channels.length; ++i) {
            if (!ChannelIdUtil.areEqualExceptForBeginTime((ChannelId)chan, (ChannelId)channels[i])) continue;
            if (!ChannelIdUtil.areEqual((ChannelId)chan, (ChannelId)channels[i])) {
                logger.debug("seismogram channel " + ChannelIdUtil.toString((ChannelId)chan) + " has a different start time than dataset channel " + ChannelIdUtil.toString((ChannelId)channels[i]));
            }
            return channels[i];
        }
        return null;
    }

    public static ChannelId getMatchingChanIdByStationCode(ChannelId chan, ChannelId[] channels) {
        for (int i = 0; i < channels.length; ++i) {
            if (!channels[i].station_code.equals(chan.station_code) || !channels[i].channel_code.equals(chan.channel_code)) continue;
            if (!ChannelIdUtil.areEqual((ChannelId)chan, (ChannelId)channels[i])) {
                logger.debug("seismogram channel " + ChannelIdUtil.toString((ChannelId)chan) + " is not totally equal to dataset channel " + ChannelIdUtil.toString((ChannelId)channels[i]));
            }
            return channels[i];
        }
        return null;
    }

    public String getOrientationId() {
        return this.orientationId;
    }

    public String getRecordSectionId() {
        return this.recordSectionId;
    }

    public String getSaveSeisId() {
        return this.saveSeisId;
    }
}

