/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.ReduceTool;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.process.waveform.FillStyle;
import edu.sc.seis.sod.process.waveform.LinearFill;
import edu.sc.seis.sod.process.waveform.Merge;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.process.waveform.ZeroFill;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class GapFill
extends Merge {
    FillStyle filler;
    private static final Logger logger = LoggerFactory.getLogger(GapFill.class);

    public GapFill(Element config) {
        if (DOMHelper.hasElement((Element)config, (String)"zeroFill")) {
            this.filler = new ZeroFill();
        } else if (DOMHelper.hasElement((Element)config, (String)"linearFill")) {
            this.filler = new LinearFill();
        }
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        int i;
        WaveformResult merged = super.accept(event, channel, original, available, ReduceTool.cutOverlap((LocalSeismogramImpl[])seismograms), cookieJar);
        List<LocalSeismogramImpl> sortedSeismograms = new ArrayList<LocalSeismogramImpl>();
        for (i = 0; i < merged.getSeismograms().length; ++i) {
            sortedSeismograms.add(merged.getSeismograms()[i]);
        }
        Collections.sort(sortedSeismograms, new Comparator<LocalSeismogramImpl>(){

            @Override
            public int compare(LocalSeismogramImpl o1, LocalSeismogramImpl o2) {
                if (o1.getBeginTime().before((Date)o2.getBeginTime())) {
                    return -1;
                }
                if (o1.getBeginTime().after((Date)o2.getBeginTime())) {
                    return 1;
                }
                return 0;
            }
        });
        for (i = 0; i < original.length; ++i) {
            MicroSecondTimeRange mstr = new MicroSecondTimeRange(original[i]);
            sortedSeismograms = this.reduce(sortedSeismograms, mstr);
        }
        return new WaveformResult(true, sortedSeismograms.toArray(new LocalSeismogramImpl[0]), this);
    }

    public List<LocalSeismogramImpl> reduce(List<LocalSeismogramImpl> inList, MicroSecondTimeRange mstr) throws FissuresException {
        System.out.println("reduce size=:" + inList.size());
        if (inList.size() == 1) {
            return inList;
        }
        LocalSeismogramImpl first = inList.remove(0);
        List<LocalSeismogramImpl> remaining = this.reduce(inList, mstr);
        LocalSeismogramImpl second = remaining.remove(0);
        LinkedList<LocalSeismogramImpl> outList = new LinkedList<LocalSeismogramImpl>();
        if (mstr.contains(first.getEndTime()) && mstr.contains(second.getBeginTime())) {
            LocalSeismogramImpl[] merged = this.gapFill(first, second);
            System.out.println("gap in window, merge.size=" + merged.length);
            for (int i = 0; i < merged.length; ++i) {
                outList.add(merged[i]);
            }
        } else {
            System.out.println("gap not in window");
            outList.add(first);
            outList.add(second);
        }
        outList.addAll(remaining);
        System.out.println("reduce finish: size=" + outList.size());
        return outList;
    }

    public LocalSeismogramImpl[] gapFill(LocalSeismogramImpl first, LocalSeismogramImpl second) throws FissuresException {
        TimeSeriesDataSel fillData = this.filler.fill(first, second);
        LocalSeismogramImpl fillSeis = new LocalSeismogramImpl(first.get_id() + "_gapFill", first.getProperties(), first.getEndTime().add(first.getSampling().getPeriod()).getFissuresTime(), GapFill.calcNumGapPoints(first, second), (Sampling)first.getSampling(), (Unit)first.getUnit(), first.getChannelID(), first.getParameterRefs(), first.time_corrections, first.sample_rate_history, fillData);
        System.out.println("Before ReduceTool.merge");
        System.out.println("First end: " + first.getEndTime());
        System.out.println("middle begin: " + fillSeis.getBeginTime());
        System.out.println("middle end: " + fillSeis.getEndTime());
        System.out.println("last begin: " + second.getBeginTime());
        LocalSeismogramImpl[] merged = ReduceTool.merge((LocalSeismogramImpl[])new LocalSeismogramImpl[]{first, fillSeis, second});
        return merged;
    }

    public static int calcNumGapPoints(LocalSeismogramImpl first, LocalSeismogramImpl second) {
        MicroSecondDate firstEnd = first.getEndTime();
        MicroSecondDate secondBegin = second.getBeginTime();
        QuantityImpl numSamplePeriods = secondBegin.subtract(firstEnd).divideBy((QuantityImpl)first.getSampling().getPeriod());
        return (int)Math.ceil(numSamplePeriods.getValue(UnitImpl.DIMENSIONLESS)) - 1;
    }
}

