/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.subsetter.VelocityFileElementParser;
import edu.sc.seis.sod.velocity.ContextWrangler;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.network.VelocityChannel;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.velocity.VelocityContext;
import org.w3c.dom.Element;

public abstract class AbstractFileWriter {
    public static final String DEFAULT_FILE_TEMPLATE_WO_EXT = "Event_${event.getTime('yyyy_MM_dd_HH_mm_ss')}/${prefix}${channel.codes}${index}";
    public static final String DEFAULT_PREFIX = "";
    public static final String DEFAULT_WORKING_DIR = "seismograms/";
    protected String workingDir;
    protected String origTemplate;
    protected String template;
    protected String prefix;
    protected SimpleVelocitizer velocitizer = new SimpleVelocitizer();
    protected static final Pattern INDEX_VAR = Pattern.compile(".*\\$\\{?index\\}?.*");

    public AbstractFileWriter(String workingDir, String fileTemplate, String prefix) {
        this.workingDir = workingDir;
        this.origTemplate = fileTemplate;
        this.prefix = prefix;
        if (!INDEX_VAR.matcher(fileTemplate).matches()) {
            fileTemplate = fileTemplate + "${index}";
        }
        VelocityFileElementParser parser = new VelocityFileElementParser(workingDir, fileTemplate);
        this.template = parser.getTemplate();
        this.prefix = prefix;
    }

    public String generate(CacheEvent event, ChannelImpl channel, LocalSeismogramImpl representativeSeismogram, int index) {
        VelocityContext ctx = ContextWrangler.createContext((EventAccessOperations)event);
        if (index > 0) {
            ctx.put("index", (Object)("." + index));
        } else {
            ctx.put("index", (Object)DEFAULT_PREFIX);
        }
        ctx.put("prefix", (Object)this.prefix);
        ContextWrangler.insertIntoContext(representativeSeismogram, (Channel)channel, ctx);
        return FissuresFormatter.filize(this.velocitizer.evaluate(this.template, ctx));
    }

    public String generate(CacheEvent event, ChannelImpl channel, ChannelImpl otherChannel, int index, Map<String, Object> extras) {
        VelocityContext ctx = ContextWrangler.createContext((EventAccessOperations)event);
        if (index > 0) {
            ctx.put("index", (Object)("." + index));
        } else {
            ctx.put("index", (Object)DEFAULT_PREFIX);
        }
        ctx.put("prefix", (Object)this.prefix);
        ContextWrangler.insertIntoContext((Channel)channel, ctx);
        ctx.put("otherChannel", (Object)new VelocityChannel(otherChannel));
        for (String key : extras.keySet()) {
            ctx.put(key, extras.get(key));
        }
        return FissuresFormatter.filize(this.velocitizer.evaluate(this.template, ctx));
    }

    public String generate(CacheEvent event, ChannelGroup channelGroup, int index, Map<String, Object> extras) {
        VelocityContext ctx = ContextWrangler.createContext((EventAccessOperations)event);
        if (index > 0) {
            ctx.put("index", (Object)("." + index));
        } else {
            ctx.put("index", (Object)DEFAULT_PREFIX);
        }
        ctx.put("prefix", (Object)this.prefix);
        ContextWrangler.insertIntoContext(channelGroup, ctx);
        for (String key : extras.keySet()) {
            ctx.put(key, extras.get(key));
        }
        return FissuresFormatter.filize(this.velocitizer.evaluate(this.template, ctx));
    }

    public void removeExisting(CacheEvent event, ChannelImpl channel, LocalSeismogramImpl representativeSeismogram) {
        File cur;
        int i = 0;
        while ((cur = new File(this.generate(event, channel, representativeSeismogram, i))).exists()) {
            cur.delete();
            ++i;
        }
    }

    public void removeExisting(CacheEvent event, ChannelImpl channel, ChannelImpl otherChannel, Map<String, Object> extras) {
        File cur;
        int i = 0;
        while ((cur = new File(this.generate(event, channel, otherChannel, i, extras))).exists()) {
            cur.delete();
            ++i;
        }
    }

    public void removeExisting(CacheEvent event, ChannelGroup channelGroup, Map<String, Object> extras) {
        File cur;
        int i = 0;
        while ((cur = new File(this.generate(event, channelGroup, i, extras))).exists()) {
            cur.delete();
            ++i;
        }
    }

    public String getTemplate() {
        return this.template;
    }

    protected static String extractFileTemplate(Element el, String def) {
        return DOMHelper.extractText((Element)el, (String)"location", (String)def);
    }

    protected static String extractPrefix(Element el) {
        return DOMHelper.extractText((Element)el, (String)"prefix", (String)DEFAULT_PREFIX);
    }

    public static String extractWorkingDir(Element el) {
        return DOMHelper.extractText((Element)el, (String)"workingDir", (String)DEFAULT_WORKING_DIR, (boolean)true);
    }

    public AbstractFileWriter() {
    }
}

