/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.sod.AbstractEventChannelPair;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.MotionVectorArm;
import edu.sc.seis.sod.Stage;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventVectorPair
extends AbstractEventChannelPair {
    ChannelGroup channelGroup;
    private static final Logger logger = LoggerFactory.getLogger(EventVectorPair.class);

    protected EventVectorPair() {
    }

    public EventVectorPair(StatefulEvent event, ChannelGroup channelGroup, EventStationPair esp) {
        this(event, channelGroup, Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT), esp);
    }

    public EventVectorPair(StatefulEvent event, ChannelGroup channelGroup, Status status, EventStationPair esp) {
        super(event, status, esp);
        this.channelGroup = channelGroup;
    }

    public ChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    protected void setChannelGroup(ChannelGroup cg) {
        this.channelGroup = cg;
    }

    @Override
    public void run() {
        try {
            ((MotionVectorArm)Start.getWaveformRecipe()).processMotionVectorArm(this);
            SodDB.commit();
            logger.debug("Finish EVP: " + this);
        }
        catch (Throwable t) {
            System.err.println("An exception occured that would've croaked a waveform worker thread!  These types of exceptions are certainly possible, but they shouldn't be allowed to percolate this far up the stack.  If you are one of those esteemed few working on SOD, it behooves you to attempt to trudge down the stack trace following this message and make certain that whatever threw this exception is no longer allowed to throw beyond its scope.  If on the other hand, you are a user of SOD it would be most appreciated if you would send an email containing the text immediately following this mesage to sod@seis.sc.edu");
            t.printStackTrace(System.err);
            GlobalExceptionHandler.handle((String)"An exception occured that would've croaked a waveform worker thread!  These types of exceptions are certainly possible, but they shouldn't be allowed to percolate this far up the stack.  If you are one of those esteemed few working on SOD, it behooves you to attempt to trudge down the stack trace following this message and make certain that whatever threw this exception is no longer allowed to throw beyond its scope.  If on the other hand, you are a user of SOD it would be most appreciated if you would send an email containing the text immediately following this mesage to sod@seis.sc.edu", (Throwable)t);
            try {
                SodDB.rollback();
                this.update(t, Status.get(Stage.PROCESSOR, Standing.SYSTEM_FAILURE));
                SodDB.commit();
            }
            catch (Throwable tt) {
                System.err.println("SOD cannot update status of evp, this indicates a significant problem with the database. SOD is now exiting with shame and dispair");
                Start.cataclysmicFailureOfUnbelievableProportions();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EventVectorPair)) {
            return false;
        }
        EventVectorPair ecp = (EventVectorPair)o;
        return ecp.getEventDbId() == this.getEventDbId() && ecp.getChannelGroup().getChannels()[0].getDbid() == this.getChannelGroup().getChannels()[0].getDbid() && ecp.getChannelGroup().getChannels()[1].getDbid() == this.getChannelGroup().getChannels()[1].getDbid() && ecp.getChannelGroup().getChannels()[2].getDbid() == this.getChannelGroup().getChannels()[2].getDbid();
    }

    @Override
    public int hashCode() {
        int code = 47 * this.getChannelGroup().getChannels()[0].getDbid();
        code += 17 * this.getChannelGroup().getChannels()[1].getDbid();
        code += 19 * this.getChannelGroup().getChannels()[2].getDbid();
        return code += 23 * this.getEventDbId();
    }

    public String toString() {
        String s = "ECGroup: " + (Object)((Object)this.getEvent()) + " ";
        s = s + ChannelIdUtil.toString((ChannelId)this.getChannelGroup().getChannels()[0].get_id()) + " , ";
        s = s + ChannelIdUtil.toString((ChannelId)this.getChannelGroup().getChannels()[1].get_id()) + " , ";
        s = s + ChannelIdUtil.toString((ChannelId)this.getChannelGroup().getChannels()[2].get_id()) + " , ";
        s = s + " " + this.getStatus();
        return s;
    }
}

