/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.event.EventAttrImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.Arm;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Stage;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import edu.sc.seis.sod.hibernate.StatefulEventDB;
import edu.sc.seis.sod.source.event.EventSource;
import edu.sc.seis.sod.status.OutputScheduler;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.eventArm.EventMonitor;
import edu.sc.seis.sod.subsetter.origin.OriginSubsetter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EventArm
implements Arm {
    static int MIN_WAIT_EVENTS = 10;
    static Status EVENT_IN_PROG = Status.get(Stage.EVENT_ORIGIN_SUBSETTER, Standing.IN_PROG);
    static Status EVENT_REJECT = Status.get(Stage.EVENT_ORIGIN_SUBSETTER, Standing.REJECT);
    private static final Status ECPOP_INIT = Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT);
    private static final Status SUCCESS = Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SUCCESS);
    private final Object waveformArmSync = new Object();
    private HashMap<EventSource, MicroSecondDate> lastTime = new HashMap();
    private List<EventSource> sources = new ArrayList<EventSource>();
    private List<OriginSubsetter> subsetters = new ArrayList<OriginSubsetter>();
    private List<EventMonitor> statusMonitors = Collections.synchronizedList(new ArrayList());
    private StatefulEventDB eventStatus;
    private boolean alive = true;
    private boolean waitForWaveformProcessing = true;
    private CacheEvent lastEvent;
    private static Logger logger = LoggerFactory.getLogger(EventArm.class);
    private static final Logger failLogger = LoggerFactory.getLogger((String)"Fail.EventArm");

    public EventArm() throws ConfigurationException {
        this(null, true);
    }

    public EventArm(Element config) throws ConfigurationException {
        this(config, true);
    }

    public EventArm(Element config, boolean waitForWaveformProcessing) throws ConfigurationException {
        this.waitForWaveformProcessing = waitForWaveformProcessing;
        this.eventStatus = StatefulEventDB.getSingleton();
        if (config != null) {
            this.processConfig(config);
        }
    }

    @Override
    public boolean isActive() {
        return this.alive;
    }

    @Override
    public String getName() {
        return "EventArm";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            for (EventSource source : this.sources) {
                logger.info(source + " covers events from " + source.getEventTimeRange());
            }
            while (!Start.isArmFailure() && this.atLeastOneSourceHasNext()) {
                this.getEvents();
            }
            logger.info("Finished processing the event arm.");
        }
        catch (Throwable e) {
            Start.armFailure(this, e);
        }
        logger.info("Event arm finished");
        this.alive = false;
        Object object = this.getWaveformArmSync();
        synchronized (object) {
            this.getWaveformArmSync().notifyAll();
        }
        object = OutputScheduler.getDefault();
        synchronized (object) {
            OutputScheduler.getDefault().notifyAll();
        }
    }

    public void add(EventMonitor monitor) {
        this.statusMonitors.add(monitor);
    }

    private void processConfig(Element config) throws ConfigurationException {
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            Object sodElement = SodUtil.load(el, new String[]{"eventArm", "origin", "event"});
            if (sodElement instanceof EventSource) {
                this.sources.add((EventSource)sodElement);
                continue;
            }
            if (!(sodElement instanceof OriginSubsetter)) continue;
            this.subsetters.add((OriginSubsetter)sodElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getEvents() throws Exception {
        Object tmpWait;
        this.waitForProcessing();
        for (EventSource source : this.sources) {
            TimeInterval wait = source.getWaitBeforeNext();
            if ((this.lastTime.get(source) == null || this.lastTime.get(source).add(wait).before((Date)ClockUtil.now())) && source.hasNext()) {
                CacheEvent[] next = source.next();
                logger.info("Handling " + next.length + " events from " + source.getDescription());
                this.handle(next);
                this.lastTime.put(source, ClockUtil.now());
                this.waitForProcessing();
                if (this.waitForWaveformProcessing && Start.isArmFailure()) {
                    logger.warn("Arm failure, " + this.getName() + " exiting early");
                    return;
                }
            }
            if (this.lastTime.get(source) != null) continue;
            this.lastTime.put(source, ClockUtil.now());
        }
        TimeInterval minWait = null;
        for (EventSource source : this.sources) {
            if (!source.hasNext() || this.lastTime.get(source) == null) continue;
            tmpWait = this.lastTime.get(source).add(source.getWaitBeforeNext()).subtract(ClockUtil.now());
            if (minWait != null && !tmpWait.lessThan((QuantityImpl)minWait)) continue;
            minWait = tmpWait;
        }
        if (minWait != null) {
            logger.debug("Wait before next getEvents: " + minWait.convertTo(UnitImpl.SECOND));
            long waitMillis = (long)minWait.convertTo(UnitImpl.MILLISECOND).get_value();
            if (waitMillis > 0L) {
                try {
                    this.setStatus("Waiting until " + ClockUtil.now().add(minWait) + " to check for new events");
                    tmpWait = this;
                    synchronized (tmpWait) {
                        this.wait(waitMillis);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    private boolean atLeastOneSourceHasNext() {
        for (EventSource source : this.sources) {
            if (!source.hasNext()) continue;
            return true;
        }
        return false;
    }

    public EventAccessOperations getLastEvent() {
        return this.lastEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForProcessing() throws Exception {
        Object object;
        int numWaiting = this.eventStatus.getNumWaiting();
        logger.debug("Event wait: numWaiting = " + numWaiting + " should be < " + MIN_WAIT_EVENTS);
        while (!Start.isArmFailure() && this.waitForWaveformProcessing && numWaiting > MIN_WAIT_EVENTS) {
            EventArm eventArm = this;
            synchronized (eventArm) {
                this.setStatus("eventArm waiting until there are less than " + MIN_WAIT_EVENTS + " events waiting to be processed. " + numWaiting + " in queue now.");
                object = this.getWaveformArmSync();
                synchronized (object) {
                    this.getWaveformArmSync().notifyAll();
                }
                this.eventStatus.rollback();
                this.wait();
            }
            numWaiting = this.eventStatus.getNumWaiting();
        }
        int numENPWaiting = SodDB.getSingleton().getNumEventNetworkWorkUnits(Standing.INIT);
        while (!Start.isArmFailure() && this.waitForWaveformProcessing && numWaiting + numENPWaiting > MIN_WAIT_EVENTS) {
            object = this;
            synchronized (object) {
                this.setStatus("eventArm waiting until there are less than " + MIN_WAIT_EVENTS + " events and event-network pairs waiting to be processed, " + (numWaiting + numENPWaiting) + " in queue now.");
                Object object2 = this.getWaveformArmSync();
                synchronized (object2) {
                    this.getWaveformArmSync().notifyAll();
                }
                this.eventStatus.rollback();
                this.wait();
            }
            numENPWaiting = SodDB.getSingleton().getNumEventNetworkWorkUnits(Standing.INIT);
        }
        logger.debug("event arm getting more events, numWaiting:" + numWaiting + " numENPWaiting:" + numENPWaiting);
        this.eventStatus.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(CacheEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            try {
                this.handle(events[i]);
                this.eventStatus.commit();
                Object object = this.getWaveformArmSync();
                synchronized (object) {
                    this.getWaveformArmSync().notifyAll();
                    continue;
                }
            }
            catch (HibernateException e) {
                this.eventStatus.rollback();
                this.handleException(e, events[i], i);
                continue;
            }
            catch (Exception e) {
                this.handleException(e, events[i], i);
                continue;
            }
            catch (Throwable e) {
                this.handleException(e, events[i], i);
            }
        }
    }

    private void handleException(Throwable t, CacheEvent event, int i) {
        GlobalExceptionHandler.handle((String)("Caught an exception for event " + i + " " + this.bestEffortEventToString((EventAccessOperations)event) + " Continuing with rest of events"), (Throwable)t);
    }

    private String bestEffortEventToString(EventAccessOperations event) {
        String s = "";
        try {
            Origin o = event.get_preferred_origin();
            s = " otime=" + o.getOriginTime().date_time;
            s = s + " loc=" + o.getLocation().latitude + ", " + o.getLocation().longitude;
        }
        catch (Throwable e) {
            s = s + e;
        }
        return s;
    }

    private void handle(CacheEvent event) throws Exception {
        logger.debug("Handle: " + event);
        StatefulEvent storedEvent = this.eventStatus.getIdenticalEvent(event);
        if (storedEvent != null) {
            return;
        }
        storedEvent = new StatefulEvent(event, EVENT_IN_PROG);
        this.eventStatus.put(storedEvent);
        this.change(storedEvent);
        if (storedEvent.getStatus() != ECPOP_INIT && storedEvent.getStatus() != SUCCESS) {
            storedEvent.setStatus(EVENT_IN_PROG);
            this.change(storedEvent);
            for (OriginSubsetter cur : this.subsetters) {
                StringTree result = cur.accept(event, (EventAttrImpl)event.get_attributes(), event.getOrigin());
                if (result.isSuccess()) continue;
                storedEvent.setStatus(EVENT_REJECT);
                this.change(storedEvent);
                failLogger.info(event + " " + result);
                return;
            }
            storedEvent.setStatus(ECPOP_INIT);
            this.change(storedEvent);
            this.lastEvent = event;
            logger.info("Successful Event: " + event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(StatefulEvent event) {
        List<EventMonitor> list = this.statusMonitors;
        synchronized (list) {
            for (EventMonitor evMon : this.statusMonitors) {
                evMon.change(event, event.getStatus());
            }
        }
    }

    public void setWaitForWaveformProcessing(boolean b) {
        this.waitForWaveformProcessing = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(String status) throws Exception {
        logger.debug(status);
        List<EventMonitor> list = this.statusMonitors;
        synchronized (list) {
            for (EventMonitor evMon : this.statusMonitors) {
                evMon.setArmStatus(status);
            }
        }
    }

    public EventSource[] getSources() {
        return this.sources.toArray(new EventSource[0]);
    }

    public Object getWaveformArmSync() {
        return this.waveformArmSync;
    }
}

