/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieEventPair;
import edu.sc.seis.sod.EventChannelPair;
import edu.sc.seis.sod.EventNetworkPair;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.source.seismogram.FixedDataCenter;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import edu.sc.seis.sod.subsetter.availableData.AvailableDataSubsetter;
import edu.sc.seis.sod.subsetter.availableData.SomeCoverage;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.PassEventStation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractWaveformRecipe {
    private Set<WaveformMonitor> statusMonitors = Collections.synchronizedSet(new HashSet());
    public static final String[] PACKAGES = new String[]{"waveformArm", "availableData", "availableData.vector", "eventChannel", "eventChannel.vector", "eventStation", "request", "request.vector", "requestGenerator", "requestGenerator.vector", "waveform", "waveform.vector", "seismogram"};
    protected EventStationSubsetter eventStation = new PassEventStation();
    protected SeismogramSourceLocator dcLocator = new FixedDataCenter();
    protected static final AvailableDataSubsetter defaultAvailableDataSubsetter = new SomeCoverage();

    public void addStatusMonitor(WaveformMonitor monitor) {
        this.statusMonitors.add(monitor);
    }

    protected abstract void handle(Element var1) throws ConfigurationException;

    protected void processConfig(Element config) throws ConfigurationException {
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element el = (Element)children.item(i);
            this.handle(el);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setStatus(CookieEventPair ecp) {
        Set<WaveformMonitor> set = this.statusMonitors;
        synchronized (set) {
            Iterator<WaveformMonitor> it = this.statusMonitors.iterator();
            while (it.hasNext()) {
                try {
                    WaveformMonitor monitor = it.next();
                    if (ecp instanceof EventChannelPair) {
                        monitor.update((EventChannelPair)ecp);
                        continue;
                    }
                    if (ecp instanceof EventVectorPair) {
                        monitor.update((EventVectorPair)ecp);
                        continue;
                    }
                    if (!(ecp instanceof EventStationPair)) continue;
                    monitor.update((EventStationPair)ecp);
                }
                catch (Exception e) {
                    GlobalExceptionHandler.handle((String)"Problem in setStatus", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setStatus(EventNetworkPair ecp) {
        Set<WaveformMonitor> set = this.statusMonitors;
        synchronized (set) {
            Iterator<WaveformMonitor> it = this.statusMonitors.iterator();
            while (it.hasNext()) {
                try {
                    it.next().update(ecp);
                }
                catch (Exception e) {
                    GlobalExceptionHandler.handle((String)"Problem in setStatus", (Throwable)e);
                }
            }
        }
    }

    public EventStationSubsetter getEventStationSubsetter() {
        return this.eventStation;
    }

    public abstract void add(WaveformProcess var1);
}

