/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.pinnacle;

import gov.usgs.util.Util;
import java.text.SimpleDateFormat;

public class StatusBlock {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private byte[] buffer;

    public StatusBlock(byte[] buf) {
        this.buffer = buf;
    }

    public static int createInt(byte b0, byte b1, byte b2, byte b3) {
        return b0 & 0xFF | (b1 & 0xFF) << 8 & 0xFF00 | (b2 & 0xFF) << 16 & 0xFF0000 | (b3 & 0xFF) << 24 & 0xFF000000 & 0xFFFFFFFF;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getTime() {
        return StatusBlock.createInt(this.buffer[0], this.buffer[1], this.buffer[2], this.buffer[3]);
    }

    public double getJ2K() {
        return Util.ewToJ2K((double)this.getTime());
    }

    public int getXCounts() {
        return StatusBlock.createInt(this.buffer[4], this.buffer[5], this.buffer[6], (byte)0);
    }

    public int getYCounts() {
        return StatusBlock.createInt(this.buffer[7], this.buffer[8], this.buffer[9], (byte)0);
    }

    public double getXMillis() {
        return (double)this.getXCounts() * 2.980232E-4 - 2500.0;
    }

    public double getYMillis() {
        return (double)this.getYCounts() * 2.980232E-4 - 2500.0;
    }

    public boolean isRezeroEnabled() {
        return (this.buffer[19] & 0x40) > 0;
    }

    public boolean isRezeroingX() {
        return (this.buffer[19] & 0x20) > 0;
    }

    public boolean isRezeroingY() {
        return (this.buffer[19] & 0x10) > 0;
    }

    public int getGain() {
        return this.buffer[19] & 3;
    }

    public int getTemperatureCounts() {
        return StatusBlock.createInt(this.buffer[12], this.buffer[13], this.buffer[14], (byte)0);
    }

    public double getTemperature() {
        return (double)this.getTemperatureCounts() * 2.980232E-5;
    }

    public int getVoltageCounts() {
        return StatusBlock.createInt(this.buffer[15], this.buffer[16], this.buffer[17], (byte)0);
    }

    public double getVoltage() {
        return (double)this.getVoltageCounts() * 3.2782552E-6;
    }

    public int getChecksum() {
        return this.buffer[31];
    }

    public String toString() {
        return String.format("StatusBlock: T: [%d/%s] X: [%d/%.3f], Y: [%d/%.3f]\n  Rezeroing: enabled: %b, X: %b, Y: %b\n       Gain: %d\nTemperature: [%d/%.3f]\n    Voltage: [%d/%.3f]", this.getTime(), this.dateFormat.format(Util.j2KToDate((double)this.getJ2K())), this.getXCounts(), this.getXMillis(), this.getYCounts(), this.getYMillis(), this.isRezeroEnabled(), this.isRezeroingX(), this.isRezeroingY(), this.getGain(), this.getTemperatureCounts(), this.getTemperature(), this.getVoltageCounts(), this.getVoltage());
    }
}

