/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.pinnacle;

import gov.usgs.net.BroadcastServer;
import gov.usgs.pinnacle.Manager;
import gov.usgs.pinnacle.PinnacleException;
import gov.usgs.pinnacle.StatusBlock;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import java.util.logging.Logger;

public class Server
extends BroadcastServer {
    private static final String CONFIG_FILE = "PinnServer.config";
    private static final String DEFAULT_LOG_FILE = "PinnServer.log";
    private static final int DEFAULT_LOG_NUM_FILES = 100;
    private static final int DEFAULT_LOG_FILE_SIZE = 10000000;
    private Manager pinnMan;
    private int interval;
    private int sampleRate;
    private Thread broadcaster;
    private int clockReset;
    private int gain;
    private String logFile;
    private int logNumFiles;
    private int logSize;

    public Server(String n, int p) {
        super(n, p);
    }

    public static Server createPinnServer() {
        ConfigFile cf = new ConfigFile(CONFIG_FILE);
        int port = Util.stringToInt((String)cf.getString("server.port"), (int)17000);
        Server ps = new Server("PinnServer", port);
        ps.logFile = Util.stringToString((String)cf.getString("log.name"), (String)DEFAULT_LOG_FILE);
        ps.logNumFiles = Util.stringToInt((String)cf.getString("log.numFiles"), (int)100);
        ps.logSize = Util.stringToInt((String)cf.getString("log.maxSize"), (int)10000000);
        if (ps.logNumFiles > 0) {
            Log.attachFileLogger((Logger)ps.logger, (String)ps.logFile, (int)ps.logSize, (int)ps.logNumFiles, (boolean)true);
        }
        String com = Util.stringToString((String)cf.getString("pinn.com"), (String)"COM1");
        int sn = Util.stringToInt((String)cf.getString("pinn.serialNumber"), (int)-1);
        if (sn == -1) {
            System.err.println("pinn.serialNumber must be in the configuration file.");
            System.exit(1);
        }
        ps.gain = Util.stringToInt((String)cf.getString("pinn.gain"), (int)1);
        ps.sampleRate = ps.interval = Util.stringToInt((String)cf.getString("server.interval"), (int)1);
        ps.interval *= 1000;
        int to = Util.stringToInt((String)cf.getString("pinn.timeout"), (int)10000);
        ps.clockReset = Util.stringToInt((String)cf.getString("server.clockReset"), (int)600);
        ps.pinnMan = new Manager(com, 9600, sn, to);
        return ps;
    }

    public void startBroadcasting() {
        this.broadcaster = new Thread(new Runnable(){

            public void run() {
                Server.this.pinnMan.openPort();
                boolean needStart = true;
                int count = 0;
                while (true) {
                    try {
                        while (true) {
                            if (needStart) {
                                Server.this.pinnMan.flushInput();
                                Server.this.logger.finer("starting data acquisition.");
                                Server.this.pinnMan.startDataAcquisition();
                                Server.this.logger.finer("setting gain.");
                                Server.this.pinnMan.setGain(Server.this.gain);
                                Server.this.logger.finer("setting sample rate.");
                                Server.this.pinnMan.setSampleRate(Server.this.sampleRate);
                                count = 0;
                            }
                            needStart = false;
                            if (count++ % Server.this.clockReset == 0) {
                                Server.this.logger.finer("setting clock.");
                                Server.this.pinnMan.setClock();
                            }
                            long st = System.currentTimeMillis();
                            StatusBlock sb = Server.this.pinnMan.getStatus();
                            long et = System.currentTimeMillis();
                            if (et - st < (long)Server.this.interval) {
                                try {
                                    Thread.sleep((long)Server.this.interval - (et - st));
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            String bs = Util.bytesToHex((byte[])sb.getBuffer());
                            String msg = "SB: " + bs;
                            Server.this.logger.finer(msg);
                            Server.this.sendMessage(msg + "\n");
                        }
                    }
                    catch (PinnacleException pe) {
                        Server.this.logger.info(pe.getMessage());
                        Server.this.logger.info("attempting reconnect.");
                        Server.this.pinnMan.close();
                        Server.this.pinnMan.openPort();
                        needStart = true;
                        continue;
                    }
                    break;
                }
            }
        });
        this.broadcaster.start();
    }

    public static void main(String[] args) {
        Server ps = Server.createPinnServer();
        ps.startBroadcasting();
        ps.startListening();
    }
}

