/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.pinnacle;

import gov.usgs.pinnacle.Command;
import gov.usgs.pinnacle.PinnacleException;
import gov.usgs.pinnacle.StatusBlock;
import gov.usgs.util.Arguments;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;

public class Manager {
    private SerialPort serialPort;
    private OutputStream outputStream;
    private InputStream inputStream;
    private String port;
    private int baud;
    private int serialNumber;
    private long lastReadTime;
    private int timeout;

    public Manager(String p, int b, int sn, int to) {
        this.port = p;
        this.baud = b;
        this.serialNumber = sn;
        this.timeout = to;
    }

    public void openPort() {
        try {
            CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)this.port);
            this.serialPort = (SerialPort)portId.open("PinnTech", 2000);
            this.outputStream = this.serialPort.getOutputStream();
            this.inputStream = this.serialPort.getInputStream();
            this.serialPort.enableReceiveTimeout(this.timeout);
            this.serialPort.setSerialPortParams(this.baud, 8, 1, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.serialPort.close();
            this.outputStream.close();
            this.inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean write(byte[] buf) {
        try {
            this.outputStream.write(buf);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public byte[] readBinary(int bytes) throws PinnacleException {
        try {
            int nr;
            byte[] buf = new byte[bytes];
            for (int total = 0; total < bytes; total += nr) {
                nr = this.inputStream.read(buf, total, bytes - total);
                if (nr == 0) {
                    throw new PinnacleException("serial read timeout.");
                }
                this.touchLastReadTime();
            }
            return buf;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void flushInput() {
        try {
            byte[] buf = new byte[256];
            while (this.inputStream.available() > 0) {
                this.inputStream.read(buf);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean ack() throws PinnacleException {
        if (this.write(Command.getACK(this.serialNumber))) {
            return this.readBinary(1) != null;
        }
        return false;
    }

    public boolean setClock() throws PinnacleException {
        if (this.write(Command.getSetClock(this.serialNumber))) {
            return this.readBinary(1) != null;
        }
        return false;
    }

    public boolean rezeroNow() throws PinnacleException {
        if (this.write(Command.getRezeroNow(this.serialNumber))) {
            return this.readBinary(1) != null;
        }
        return false;
    }

    public boolean startDataAcquisition() throws PinnacleException {
        if (this.write(Command.getStartDataAcquisition(this.serialNumber))) {
            return this.readBinary(1) != null;
        }
        return false;
    }

    public StatusBlock getStatus() throws PinnacleException {
        this.write(Command.getStatus(this.serialNumber));
        byte[] buf = this.readBinary(32);
        byte total = 0;
        for (int i = 0; i < buf.length - 1; ++i) {
            total += buf[i];
        }
        if ((total = 0xFF & total) != buf[31]) {
            throw new PinnacleException("checksum doesn't match.");
        }
        StatusBlock sb = new StatusBlock(buf);
        return sb;
    }

    public boolean setGain(int gain) throws PinnacleException {
        if (this.write(Command.getSetGain(this.serialNumber, gain))) {
            return this.readBinary(1) != null;
        }
        return false;
    }

    public boolean setSampleRate(int sr) throws PinnacleException {
        if (this.write(Command.getSetSampleRate(this.serialNumber, sr))) {
            return this.readBinary(1) != null;
        }
        return false;
    }

    public boolean set9600() throws PinnacleException {
        return false;
    }

    public synchronized long getLastReadTime() {
        return this.lastReadTime;
    }

    protected synchronized void touchLastReadTime() {
        this.lastReadTime = System.currentTimeMillis();
    }

    public static void main(String[] as) throws PinnacleException {
        HashSet<String> flags = new HashSet<String>();
        flags.add("-3");
        flags.add("--38400");
        flags.add("-9");
        flags.add("--9600");
        flags.add("-a");
        flags.add("--ack");
        flags.add("-s");
        flags.add("--status");
        flags.add("-t");
        flags.add("--time");
        flags.add("-z");
        flags.add("--zero");
        HashSet<String> kvs = new HashSet<String>();
        kvs.add("-p");
        kvs.add("--port");
        Arguments args = new Arguments(as, flags, kvs);
        String port = "COM1";
        int baud = 9600;
        int serialNumber = 6266;
        Manager pm = new Manager(port, baud, serialNumber, 10000);
        pm.openPort();
        if (args.flagged("-a") || args.flagged("--ack")) {
            System.out.println("ack: " + pm.ack());
        }
        if (args.flagged("-s") || args.flagged("--status")) {
            System.out.println(pm.getStatus());
        }
        if (args.flagged("-t") || args.flagged("--time")) {
            System.out.println(pm.setClock());
        }
        if (args.flagged("-z") || args.flagged("--zero")) {
            System.out.println(pm.rezeroNow());
        }
    }
}

