/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.pinnacle;

import gov.usgs.util.CurrentTime;

public class Command {
    public static void setChecksum(byte[] buf) {
        int total = 0;
        for (int i = 0; i < buf.length - 1; ++i) {
            total += buf[i];
        }
        buf[buf.length - 1] = (byte)(0xFF & total);
    }

    public static byte[] getACK(int id) {
        byte[] cmd = new byte[5];
        cmd[0] = 22;
        cmd[1] = (byte)(0xFF & id);
        cmd[2] = (byte)((0xFF00 & id) >> 8);
        cmd[3] = 40;
        Command.setChecksum(cmd);
        return cmd;
    }

    public static byte[] get38400Baud(int id) {
        byte[] cmd = new byte[5];
        cmd[0] = 22;
        cmd[1] = (byte)(0xFF & id);
        cmd[2] = (byte)((0xFF00 & id) >> 8);
        cmd[3] = 3;
        Command.setChecksum(cmd);
        return cmd;
    }

    public static byte[] getStatus(int id) {
        byte[] cmd = new byte[5];
        cmd[0] = 22;
        cmd[1] = (byte)(0xFF & id);
        cmd[2] = (byte)((0xFF00 & id) >> 8);
        cmd[3] = 0;
        Command.setChecksum(cmd);
        return cmd;
    }

    public static byte[] getCurrentBlockIndex(int id) {
        byte[] cmd = new byte[5];
        cmd[0] = 22;
        cmd[1] = (byte)(0xFF & id);
        cmd[2] = (byte)((0xFF00 & id) >> 8);
        cmd[3] = 28;
        Command.setChecksum(cmd);
        return cmd;
    }

    public static byte[] stopDA(int id) {
        byte[] cmd = new byte[5];
        cmd[0] = 22;
        cmd[1] = (byte)(0xFF & id);
        cmd[2] = (byte)((0xFF00 & id) >> 8);
        cmd[3] = 11;
        Command.setChecksum(cmd);
        return cmd;
    }

    public static byte[] startDA(int id) {
        byte[] cmd = new byte[5];
        cmd[0] = 22;
        cmd[1] = (byte)(0xFF & id);
        cmd[2] = (byte)((0xFF00 & id) >> 8);
        cmd[3] = 10;
        Command.setChecksum(cmd);
        return cmd;
    }

    public static byte[] getBlock(int id, int block) {
        byte[] cmd = new byte[7];
        cmd[0] = 22;
        cmd[1] = (byte)(0xFF & id);
        cmd[2] = (byte)((0xFF00 & id) >> 8);
        cmd[3] = 25;
        cmd[4] = (byte)(0xFF & block);
        cmd[5] = (byte)((0xFF00 & block) >> 8);
        Command.setChecksum(cmd);
        return cmd;
    }

    public static byte[] getDataHeader(int id, int block) {
        byte[] cmd = new byte[7];
        cmd[0] = 22;
        cmd[1] = (byte)(0xFF & id);
        cmd[2] = (byte)((0xFF00 & id) >> 8);
        cmd[3] = 27;
        cmd[4] = (byte)(0xFF & block);
        cmd[5] = (byte)((0xFF00 & block) >> 8);
        Command.setChecksum(cmd);
        return cmd;
    }

    public static byte[] getRezeroNow(int id) {
        byte[] cmd = new byte[5];
        cmd[0] = 22;
        cmd[1] = (byte)(0xFF & id);
        cmd[2] = (byte)((0xFF00 & id) >> 8);
        cmd[3] = 31;
        Command.setChecksum(cmd);
        return cmd;
    }

    public static byte[] getStartDataAcquisition(int id) {
        byte[] cmd = new byte[5];
        cmd[0] = 22;
        cmd[1] = (byte)(0xFF & id);
        cmd[2] = (byte)((0xFF00 & id) >> 8);
        cmd[3] = 10;
        Command.setChecksum(cmd);
        return cmd;
    }

    public static byte[] getSetGain(int id, int gain) {
        byte[] cmd = new byte[6];
        cmd[0] = 22;
        cmd[1] = (byte)(0xFF & id);
        cmd[2] = (byte)((0xFF00 & id) >> 8);
        cmd[3] = 34;
        cmd[4] = (byte)(0xFF & gain);
        Command.setChecksum(cmd);
        return cmd;
    }

    public static byte[] getSetSampleRate(int id, int sr) {
        byte[] cmd = new byte[6];
        cmd[0] = 22;
        cmd[1] = (byte)(0xFF & id);
        cmd[2] = (byte)((0xFF00 & id) >> 8);
        cmd[3] = 15;
        cmd[4] = (byte)(0xFF & sr);
        Command.setChecksum(cmd);
        return cmd;
    }

    public static byte[] getSetClock(int id) {
        byte[] cmd = new byte[9];
        cmd[0] = 22;
        cmd[1] = (byte)(0xFF & id);
        cmd[2] = (byte)((0xFF00 & id) >> 8);
        cmd[3] = 20;
        int sec = (int)Math.round((double)CurrentTime.getInstance().now() / 1000.0);
        cmd[4] = (byte)((0xFF000000 & sec) >> 24);
        cmd[5] = (byte)((0xFF0000 & sec) >> 16);
        cmd[6] = (byte)((0xFF00 & sec) >> 8);
        cmd[7] = (byte)(0xFF & sec);
        Command.setChecksum(cmd);
        return cmd;
    }
}

