/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.network;

import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.network.SiteIdUtil;
import edu.iris.Fissures.network.SiteImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.network.VelocityNetwork;
import edu.sc.seis.sod.velocity.network.VelocityStation;
import org.apache.velocity.VelocityContext;

public class VelocitySite
extends Site {
    private SiteImpl site;

    public VelocitySite(SiteImpl s) {
        this.site = s;
        this.my_location = s.getLocation();
        this.effective_time = s.getEffectiveTime();
        this.setStation(s.getStation());
        this.comment = s.getComment();
    }

    public SiteId get_id() {
        return this.site.get_id();
    }

    public String get_code() {
        return this.site.get_code();
    }

    public String getCode() {
        return this.get_code();
    }

    public String getCodes() {
        return this.getNet().getCode() + "." + this.getStation().getCode() + "." + this.getCode();
    }

    public VelocityStation getStation() {
        return new VelocityStation((StationImpl)this.site.getStation());
    }

    public VelocityNetwork getNet() {
        return this.getStation().getNet();
    }

    public MicroSecondDate getStartDate() {
        return new MicroSecondDate(this.effective_time.start_time);
    }

    public MicroSecondDate getEndDate() {
        return new MicroSecondDate(this.effective_time.end_time);
    }

    public String getStart() {
        return FissuresFormatter.formatDate(this.effective_time.start_time);
    }

    public String getStart(String dateFormat) {
        if (dateFormat.equals("longfile")) {
            return FissuresFormatter.formatDateForFile(this.effective_time.start_time);
        }
        return SimpleVelocitizer.format(new MicroSecondDate(this.effective_time.start_time), dateFormat);
    }

    public String getEnd() {
        return FissuresFormatter.formatDate(this.effective_time.end_time);
    }

    public String getEnd(String dateFormat) {
        if (dateFormat.equals("longfile")) {
            return FissuresFormatter.formatDateForFile(this.effective_time.end_time);
        }
        return SimpleVelocitizer.format(new MicroSecondDate(this.effective_time.end_time), dateFormat);
    }

    public String getComment() {
        return this.comment;
    }

    public String getLatitude() {
        return VelocityStation.df.format(this.site.getLocation().latitude);
    }

    public String getLongitude() {
        return VelocityStation.df.format(this.site.getLocation().longitude);
    }

    public String getOrientedLatitude() {
        if (this.site.getLocation().latitude < 0.0f) {
            return VelocityStation.df.format(-this.site.getLocation().latitude) + " S";
        }
        return VelocityStation.df.format(this.site.getLocation().latitude) + " N";
    }

    public String getOrientedLongitude() {
        if (this.site.getLocation().longitude < 0.0f) {
            return VelocityStation.df.format(-this.site.getLocation().longitude) + " W";
        }
        return VelocityStation.df.format(this.site.getLocation().longitude) + " E";
    }

    public String getDepth() {
        return FissuresFormatter.formatDepth(QuantityImpl.createQuantityImpl((Quantity)this.site.getLocation().depth));
    }

    public String toString() {
        return SiteIdUtil.toString((SiteId)this.get_id());
    }

    public void insertIntoContext(VelocityContext ctx) {
        ctx.put("site", (Object)this);
        this.getStation().insertIntoContext(ctx);
    }
}

